/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.content.clipboard;

import com.github.minecraftschurlimods.bibliocraft.content.clipboard.ClipboardContent;
import com.github.minecraftschurlimods.bibliocraft.init.BCBlockEntities;
import com.github.minecraftschurlimods.bibliocraft.init.BCDataComponents;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ClipboardBlockEntity
extends BlockEntity {
    private static final String CONTENT_KEY = "clipboard_content";
    private ClipboardContent content = ClipboardContent.DEFAULT;

    public ClipboardBlockEntity(BlockPos pos, BlockState blockState) {
        super(BCBlockEntities.CLIPBOARD.get(), pos, blockState);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains(CONTENT_KEY)) {
            this.setContent(BCUtil.decodeNbt(ClipboardContent.CODEC, tag.get(CONTENT_KEY)));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put(CONTENT_KEY, BCUtil.encodeNbt(ClipboardContent.CODEC, this.getContent()));
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.setContent((ClipboardContent)componentInput.getOrDefault(BCDataComponents.CLIPBOARD_CONTENT, (Object)ClipboardContent.DEFAULT));
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        if (!this.content.equals(ClipboardContent.DEFAULT)) {
            components.set(BCDataComponents.CLIPBOARD_CONTENT, (Object)this.content);
        }
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove(CONTENT_KEY);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        if (!this.content.equals(ClipboardContent.DEFAULT)) {
            tag.put(CONTENT_KEY, BCUtil.encodeNbt(ClipboardContent.CODEC, this.getContent()));
        }
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        if (tag.contains(CONTENT_KEY)) {
            this.setContent(BCUtil.decodeNbt(ClipboardContent.CODEC, tag.get(CONTENT_KEY)));
        }
    }

    public ClipboardContent getContent() {
        return this.content;
    }

    public void setContent(ClipboardContent content) {
        this.content = content;
        this.setChanged();
    }
}

