/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.client;

import com.github.minecraftschurlimods.bibliocraft.content.clipboard.CheckboxState;
import com.github.minecraftschurlimods.bibliocraft.content.clipboard.ClipboardContent;
import com.github.minecraftschurlimods.bibliocraft.util.BCUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public final class ClipboardReadOnlyRenderer {
    private static final ResourceLocation BACKGROUND = BCUtil.modLoc("textures/gui/clipboard_block.png");
    private static final ResourceLocation CHECK_TEXTURE = BCUtil.modLoc("check");
    private static final ResourceLocation X_TEXTURE = BCUtil.modLoc("x");

    public static void render(PoseStack pose, MultiBufferSource bufferSource, ClipboardContent data, int width, int height) {
        pose.pushPose();
        RenderSystem.enableDepthTest();
        ClipboardReadOnlyRenderer.blit(pose, BACKGROUND, 0.0f, 0.0f, 0.0f, 0.0f, width, height, 256.0f, 256.0f);
        RenderSystem.disableDepthTest();
        ClipboardReadOnlyRenderer.drawText(pose, bufferSource, data.title(), 29.0f, 2.0f, 72, 8);
        ClipboardContent.Page page = data.pages().get(data.active());
        for (int i = 0; i < 9; ++i) {
            CheckboxState state = page.checkboxes().get(i);
            if (state == CheckboxState.CHECK) {
                ClipboardReadOnlyRenderer.blitSprite(pose, CHECK_TEXTURE, 2, 15 * i + 14, 14, 14);
            } else if (state == CheckboxState.X) {
                ClipboardReadOnlyRenderer.blitSprite(pose, X_TEXTURE, 2, 15 * i + 14, 14, 14);
            }
            ClipboardReadOnlyRenderer.drawText(pose, bufferSource, page.lines().get(i), 17.0f, 15 * i + 16, 109, 8);
        }
        pose.popPose();
    }

    private static void drawText(PoseStack pose, MultiBufferSource bufferSource, String text, float x, float y, int width, int height) {
        Font font = Minecraft.getInstance().font;
        String visibleText = font.plainSubstrByWidth(text, width);
        if (visibleText.isEmpty()) {
            return;
        }
        font.drawInBatch(visibleText, x, y, 0, false, pose.last().pose(), bufferSource, Font.DisplayMode.POLYGON_OFFSET, 0, 0xF000F0, font.isBidirectional());
    }

    private static void blitSprite(PoseStack pose, ResourceLocation location, int x, int y, int width, int height) {
        TextureAtlasSprite sprite = Minecraft.getInstance().getGuiSprites().getSprite(location);
        ClipboardReadOnlyRenderer.innerBlit(pose, sprite.atlasLocation(), x, x + width, y, y + width, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1());
    }

    private static void blit(PoseStack pose, ResourceLocation atlasLocation, float x, float y, float uOffset, float vOffset, float uWidth, float vHeight, float textureWidth, float textureHeight) {
        float minU = uOffset / textureWidth;
        float maxU = (uOffset + uWidth) / textureWidth;
        float minV = vOffset / textureHeight;
        float maxV = (vOffset + vHeight) / textureHeight;
        ClipboardReadOnlyRenderer.innerBlit(pose, atlasLocation, x, x + uWidth, y, y + vHeight, minU, maxU, minV, maxV);
    }

    private static void innerBlit(PoseStack pose, ResourceLocation atlasLocation, float x1, float x2, float y1, float y2, float minU, float maxU, float minV, float maxV) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)atlasLocation);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix4f = pose.last().pose();
        BufferBuilder bb = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bb.addVertex(matrix4f, x1, y1, 0.0f).setUv(minU, minV);
        bb.addVertex(matrix4f, x1, y2, 0.0f).setUv(minU, maxV);
        bb.addVertex(matrix4f, x2, y2, 0.0f).setUv(maxU, maxV);
        bb.addVertex(matrix4f, x2, y1, 0.0f).setUv(maxU, minV);
        BufferUploader.drawWithShader((MeshData)bb.buildOrThrow());
    }
}

