/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.apiimpl;

import com.github.minecraftschurlimods.bibliocraft.api.woodtype.BibliocraftWoodType;
import com.github.minecraftschurlimods.bibliocraft.api.woodtype.BibliocraftWoodTypeRegistry;
import com.github.minecraftschurlimods.bibliocraft.api.woodtype.RegisterBibliocraftWoodTypesEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.SequencedMap;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class BibliocraftWoodTypeRegistryImpl
implements BibliocraftWoodTypeRegistry {
    private final SequencedMap<ResourceLocation, BibliocraftWoodType> values = new LinkedHashMap<ResourceLocation, BibliocraftWoodType>();
    private boolean loaded = false;

    @ApiStatus.Internal
    public BibliocraftWoodTypeRegistryImpl() {
    }

    @ApiStatus.Internal
    public void register() {
        LinkedHashMap<ResourceLocation, BibliocraftWoodType> registrar = new LinkedHashMap<ResourceLocation, BibliocraftWoodType>();
        ModLoader.postEvent((Event)new RegisterBibliocraftWoodTypesEvent(registrar));
        registrar.sequencedEntrySet().stream().sorted((a, b) -> BibliocraftWoodTypeRegistryImpl.compareRLMinecraftFirst((ResourceLocation)a.getKey(), (ResourceLocation)b.getKey())).forEach(e -> this.values.put((ResourceLocation)e.getKey(), (BibliocraftWoodType)e.getValue()));
        this.loaded = true;
    }

    @Override
    @Nullable
    public BibliocraftWoodType get(ResourceLocation id) {
        if (!this.loaded) {
            throw new IllegalStateException("Tried to access BibliocraftWoodTypeRegistry#get() before registration was done!");
        }
        return (BibliocraftWoodType)this.values.get(id);
    }

    @Override
    public Collection<BibliocraftWoodType> getAll() {
        if (!this.loaded) {
            throw new IllegalStateException("Tried to access BibliocraftWoodTypeRegistry#getAll() before registration was done!");
        }
        return this.values.sequencedValues();
    }

    private static int compareRLMinecraftFirst(ResourceLocation a, ResourceLocation b) {
        String namespaceB;
        String namespaceA = a.getNamespace();
        if (namespaceA.equals(namespaceB = b.getNamespace())) {
            return 0;
        }
        if (namespaceA.equals("minecraft")) {
            return -1;
        }
        if (namespaceB.equals("minecraft")) {
            return 1;
        }
        return namespaceA.compareTo(namespaceB);
    }
}

