/*
 * Decompiled with CFR 0.152.
 */
package com.github.minecraftschurlimods.bibliocraft.api;

import com.github.minecraftschurlimods.bibliocraft.api.datagen.BibliocraftDatagenHelper;
import com.github.minecraftschurlimods.bibliocraft.api.lockandkey.LockAndKeyBehaviors;
import com.github.minecraftschurlimods.bibliocraft.api.woodtype.BibliocraftWoodTypeRegistry;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.LoggerFactory;

@ApiStatus.NonExtendable
public interface BibliocraftApi {
    public static final String MOD_ID = "bibliocraft";

    public static BibliocraftDatagenHelper getDatagenHelper() {
        return (BibliocraftDatagenHelper)InstanceHolder.DATAGEN_HELPER.get();
    }

    public static BibliocraftWoodTypeRegistry getWoodTypeRegistry() {
        return (BibliocraftWoodTypeRegistry)InstanceHolder.WOOD_TYPE_REGISTRY.get();
    }

    public static LockAndKeyBehaviors getLockAndKeyBehaviors() {
        return (LockAndKeyBehaviors)InstanceHolder.LOCK_AND_KEY_BEHAVIORS.get();
    }

    @ApiStatus.Internal
    public static final class InstanceHolder {
        private static final Lazy<BibliocraftDatagenHelper> DATAGEN_HELPER = Lazy.of(InstanceHolder.fromServiceLoader(BibliocraftDatagenHelper.class));
        private static final Lazy<BibliocraftWoodTypeRegistry> WOOD_TYPE_REGISTRY = Lazy.of(InstanceHolder.fromServiceLoader(BibliocraftWoodTypeRegistry.class));
        private static final Lazy<LockAndKeyBehaviors> LOCK_AND_KEY_BEHAVIORS = Lazy.of(InstanceHolder.fromServiceLoader(LockAndKeyBehaviors.class));

        private InstanceHolder() {
        }

        private static <T> Supplier<T> fromServiceLoader(Class<T> clazz) {
            return () -> {
                Optional impl = ServiceLoader.load(FMLLoader.getGameLayer(), clazz).findFirst();
                String msg = "Unable to find implementation for " + clazz.getSimpleName() + "!";
                if (!FMLEnvironment.production) {
                    return impl.orElseThrow(() -> {
                        IllegalStateException exception = new IllegalStateException(msg);
                        LoggerFactory.getLogger((String)BibliocraftApi.MOD_ID).error(exception.getMessage(), (Throwable)exception);
                        return exception;
                    });
                }
                return impl.orElseGet(() -> {
                    LoggerFactory.getLogger((String)BibliocraftApi.MOD_ID).error(msg);
                    return null;
                });
            };
        }
    }
}

