/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.integration.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.ProcessingViaFanCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedKinetics;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.simibubi.create.foundation.item.ItemHelper;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeType;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.registries.DeferredHolder;
import plus.dragons.createdragonsplus.common.CDPCommon;
import plus.dragons.createdragonsplus.common.fluids.dye.DyeColors;
import plus.dragons.createdragonsplus.common.kinetics.fan.coloring.ColoringRecipe;
import plus.dragons.createdragonsplus.common.registry.CDPFluids;
import plus.dragons.createdragonsplus.common.registry.CDPRecipes;
import plus.dragons.createdragonsplus.data.internal.CDPLang;
import plus.dragons.createdragonsplus.integration.ModIntegration;
import plus.dragons.createdragonsplus.integration.jei.CDPJeiPlugin;
import plus.dragons.createdragonsplus.integration.jei.widget.FanProcessingIcon;
import plus.dragons.createdragonsplus.util.FieldsNullabilityUnknownByDefault;

public class FanColoringCategory
extends ProcessingViaFanCategory<ColoringRecipe> {
    public static final RecipeType<RecipeHolder<ColoringRecipe>> TYPE = RecipeType.createRecipeHolderType((ResourceLocation)CDPRecipes.COLORING.getId());

    private FanColoringCategory(CreateRecipeCategory.Info<ColoringRecipe> info) {
        super(info);
    }

    public static FanColoringCategory create() {
        ResourceLocation id = CDPCommon.asResource("fan_coloring");
        MutableComponent title = CDPLang.description("recipe", id, new Object[0]).component();
        EmptyBackground background = new EmptyBackground(178, 72);
        Icon icon = new Icon();
        ItemStack catalyst = AllBlocks.ENCASED_FAN.asStack();
        catalyst.set(DataComponents.CUSTOM_NAME, (Object)CDPLang.description("recipe", id, "fan", new Object[0]).component().withStyle(style -> style.withItalic(Boolean.valueOf(false))));
        CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(TYPE, (Component)title, (IDrawable)background, (IDrawable)icon, FanColoringCategory::getAllRecipes, List.of(() -> catalyst));
        return new FanColoringCategory((CreateRecipeCategory.Info<ColoringRecipe>)info);
    }

    public void draw(ColoringRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.renderWidgets(graphics, (Recipe)recipe, mouseX, mouseY);
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        this.translateFan(matrixStack);
        matrixStack.mulPose(Axis.XP.rotationDegrees(-12.5f));
        matrixStack.mulPose(Axis.YP.rotationDegrees(22.5f));
        AnimatedKinetics.defaultBlockElement((PartialModel)AllPartialModels.ENCASED_FAN_INNER).rotateBlock(180.0, 0.0, (double)(AnimatedKinetics.getCurrentAngle() * 16.0f)).scale(24.0).render(graphics);
        AnimatedKinetics.defaultBlockElement((BlockState)AllBlocks.ENCASED_FAN.getDefaultState()).rotateBlock(0.0, 180.0, 0.0).atLocal(0.0, 0.0, 0.0).scale(24.0).render(graphics);
        this.renderAttachedBlock(graphics, recipe.getColor());
        matrixStack.popPose();
    }

    protected void renderAttachedBlock(GuiGraphics graphics, DyeColor color) {
        GuiGameElement.of((Fluid)CDPFluids.DYES_BY_COLOR.get(color).getSource()).scale(24.0).atLocal(0.0, 0.0, 2.0).lighting(AnimatedKinetics.DEFAULT_LIGHTING).render(graphics);
    }

    @Deprecated
    protected void renderAttachedBlock(GuiGraphics graphics) {
    }

    private static List<RecipeHolder<ColoringRecipe>> getAllRecipes() {
        Level level = CDPJeiPlugin.getLevel();
        RecipeManager manager = CDPJeiPlugin.getRecipeManager();
        ArrayList<RecipeHolder<ColoringRecipe>> recipes = new ArrayList<RecipeHolder<ColoringRecipe>>(manager.getAllRecipesFor(CDPRecipes.COLORING.getType()));
        for (DyeColor color : DyeColors.ALL) {
            DeferredHolder createGarnishedRecipe = DeferredHolder.create((ResourceKey)Registries.RECIPE_TYPE, (ResourceLocation)ModIntegration.CREATE_GARNISHED.asResource(color.getSerializedName() + "_dye_blowing"));
            if (!createGarnishedRecipe.isBound()) continue;
            manager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)createGarnishedRecipe.get()).forEach(holder -> recipes.add(new RecipeHolder(holder.id(), (Recipe)((ColoringRecipe)((ColoringRecipe.Builder)((ColoringRecipe.Builder)ColoringRecipe.builder(holder.id(), color).withItemIngredients(((StandardProcessingRecipe)holder.value()).getIngredients())).withItemOutputs((ProcessingOutput[])((StandardProcessingRecipe)holder.value()).getRollableResults().toArray(ProcessingOutput[]::new))).build()))));
        }
        for (RecipeHolder holder2 : manager.getAllRecipesFor(net.minecraft.world.item.crafting.RecipeType.CRAFTING)) {
            CraftingRecipe crafting = (CraftingRecipe)holder2.value();
            if (crafting.isSpecial()) continue;
            NonNullList ingredients = crafting.getIngredients();
            ItemStack result = crafting.getResultItem((HolderLookup.Provider)level.registryAccess());
            if (crafting.canCraftInDimensions(2, 1) && ingredients.size() == 2 && result.getCount() == 1) {
                for (DyeColor color : DyeColors.ALL) {
                    FanColoringCategory.convert2x1(holder2.id().withSuffix("_as_coloring"), color, (List<Ingredient>)ingredients, result).ifPresent(recipes::add);
                }
                continue;
            }
            if (!crafting.canCraftInDimensions(3, 3) || ingredients.size() != 9 || result.getCount() != 8) continue;
            for (DyeColor color : DyeColors.ALL) {
                FanColoringCategory.convert3x3(holder2.id().withSuffix("_as_coloring"), color, (List<Ingredient>)ingredients, result).ifPresent(recipes::add);
            }
        }
        recipes.sort(Comparator.comparing(holder -> ((ColoringRecipe)holder.value()).getColor(), DyeColors.creativeModeTabOrder()).thenComparing(RecipeHolder::id));
        return recipes;
    }

    private static Optional<RecipeHolder<ColoringRecipe>> convert2x1(ResourceLocation id, DyeColor color, List<Ingredient> ingredients, ItemStack result) {
        ItemStack dye = new ItemStack((ItemLike)DyeItem.byColor((DyeColor)color));
        if (ingredients.get(0).test(dye)) {
            ColoringRecipe recipe = (ColoringRecipe)((ColoringRecipe.Builder)((ColoringRecipe.Builder)ColoringRecipe.builder(id, color).require(ingredients.get(1))).output(result)).build();
            return Optional.of(new RecipeHolder(id, (Recipe)recipe));
        }
        if (ingredients.get(1).test(dye)) {
            ColoringRecipe recipe = (ColoringRecipe)((ColoringRecipe.Builder)((ColoringRecipe.Builder)ColoringRecipe.builder(id, color).require(ingredients.get(0))).output(result)).build();
            return Optional.of(new RecipeHolder(id, (Recipe)recipe));
        }
        return Optional.empty();
    }

    private static Optional<RecipeHolder<ColoringRecipe>> convert3x3(ResourceLocation id, DyeColor color, List<Ingredient> ingredients, ItemStack result) {
        ItemStack dye = new ItemStack((ItemLike)DyeItem.byColor((DyeColor)color));
        Ingredient dyeable = null;
        boolean hasDye = false;
        for (Ingredient ingredient : ingredients) {
            if (ingredient.hasNoItems()) {
                return Optional.empty();
            }
            if (ingredient.test(dye)) {
                if (hasDye) {
                    return Optional.empty();
                }
                hasDye = true;
                continue;
            }
            if (dyeable == null) {
                dyeable = ingredient;
                continue;
            }
            if (ItemHelper.matchIngredients((Ingredient)dyeable, (Ingredient)ingredient)) continue;
            return Optional.empty();
        }
        if (!hasDye || dyeable == null) {
            return Optional.empty();
        }
        ColoringRecipe recipe = (ColoringRecipe)((ColoringRecipe.Builder)((ColoringRecipe.Builder)ColoringRecipe.builder(id, color).require(dyeable)).output(result.copyWithCount(1))).build();
        return Optional.of(new RecipeHolder(id, (Recipe)recipe));
    }

    @FieldsNullabilityUnknownByDefault
    protected static class Icon
    extends FanProcessingIcon {
        private ItemStack[] catalystStacks;

        protected Icon() {
        }

        @Override
        protected ItemStack getCatalyst() {
            if (this.catalystStacks == null) {
                this.catalystStacks = (ItemStack[])Arrays.stream(DyeColors.ALL).map(CDPFluids.DYES_BY_COLOR::get).flatMap(entry -> entry.getBucket().stream()).map(ItemStack::new).toArray(ItemStack[]::new);
            }
            return this.catalystStacks[AnimationTickHolder.getTicks() / 20 % this.catalystStacks.length];
        }
    }
}

