/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.common.fluids.dye;

import com.tterrag.registrate.builders.FluidBuilder;
import java.util.function.Supplier;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.joml.Vector3f;
import plus.dragons.createdragonsplus.common.fluids.SolidRenderFluidType;
import plus.dragons.createdragonsplus.config.CDPConfig;

public final class DyeFluidType
extends SolidRenderFluidType {
    private final DyeColor color;

    private DyeFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture, int tintColor, Vector3f fogColor, Supplier<Float> fogDistanceModifier, DyeColor color) {
        super(properties, stillTexture, flowingTexture, tintColor, fogColor, fogDistanceModifier);
        this.color = color;
    }

    public static FluidBuilder.FluidTypeFactory create(DyeColor color) {
        int tintColor = FastColor.ARGB32.opaque((int)color.getTextureDiffuseColor());
        Vector3f fogColor = new Color(tintColor).asVectorF();
        return (properties, stillTexture, flowingTexture) -> new DyeFluidType(properties, stillTexture, flowingTexture, tintColor, fogColor, DyeFluidType::getVisibility, color);
    }

    private static float getVisibility() {
        return CDPConfig.client().dyeVisionMultiplier.getF() / 256.0f;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public boolean isVaporizedOnPlacement(Level level, BlockPos pos, FluidStack stack) {
        return level.dimensionType().ultraWarm();
    }
}

