/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.packmenu.buttons;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.packmenu.ExtendedMenuScreen;
import dev.shadowsoffire.packmenu.buttons.AnchorPoint;
import dev.shadowsoffire.packmenu.buttons.ButtonAction;
import dev.shadowsoffire.packmenu.buttons.ButtonIcon;
import dev.shadowsoffire.packmenu.buttons.ButtonText;
import dev.shadowsoffire.packmenu.buttons.WidgetSpritesCodec;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;

public class JsonButton
extends Button {
    public static final String MESSAGE_SEPARATOR = "      ";
    public static final Codec<JsonButton> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("x").forGetter(JsonButton::getXPos), (App)Codec.INT.fieldOf("y").forGetter(JsonButton::getYPos), (App)Codec.intRange((int)0, (int)Short.MAX_VALUE).fieldOf("width").forGetter(AbstractWidget::getWidth), (App)Codec.intRange((int)0, (int)Short.MAX_VALUE).fieldOf("height").forGetter(AbstractWidget::getHeight), (App)AnchorPoint.CODEC.optionalFieldOf("anchor", (Object)AnchorPoint.DEFAULT).forGetter(JsonButton::getAnchor), (App)WidgetSpritesCodec.INSTANCE.optionalFieldOf("sprites", (Object)SPRITES).forGetter(JsonButton::getSprites), (App)ButtonIcon.CODEC.optionalFieldOf("icon", (Object)ButtonIcon.EMPTY).forGetter(JsonButton::getIcon), (App)ButtonIcon.CODEC.optionalFieldOf("hover_icon").forGetter(JsonButton::getHoverIcon), (App)ButtonAction.CODEC.fieldOf("action").forGetter(JsonButton::getAction), (App)ButtonText.CODEC.optionalFieldOf("text", (Object)ButtonText.EMPTY).forGetter(JsonButton::getText), (App)ButtonText.CODEC.optionalFieldOf("hover_text").forGetter(JsonButton::getHoverText), (App)Codec.BOOL.optionalFieldOf("active", (Object)true).forGetter(AbstractWidget::isActive), (App)Codec.FLOAT.optionalFieldOf("scale_x", (Object)Float.valueOf(1.0f)).forGetter(JsonButton::getScaleX), (App)Codec.FLOAT.optionalFieldOf("scale_y", (Object)Float.valueOf(1.0f)).forGetter(JsonButton::getScaleY)).apply((Applicative)inst, JsonButton::new));
    protected final int xOff;
    protected final int yOff;
    protected final AnchorPoint anchor;
    protected final WidgetSprites sprites;
    protected final ButtonIcon icon;
    protected final Optional<ButtonIcon> hoverIcon;
    protected final ButtonAction action;
    protected final ButtonText text;
    protected final Optional<ButtonText> hoverText;
    protected final float scaleX;
    protected final float scaleY;
    protected int scrollCounter = 0;
    protected Component hoverMessage;

    public JsonButton(int xPos, int yPos, int width, int height, AnchorPoint anchor, WidgetSprites sprites, ButtonIcon icon, Optional<ButtonIcon> hoverIcon, ButtonAction action, ButtonText text, Optional<ButtonText> hoverText, boolean active, float scaleX, float scaleY) {
        super(xPos, yPos, width, height, (Component)Component.translatable((String)text.key()), (Button.OnPress)action, Button.DEFAULT_NARRATION);
        this.xOff = xPos;
        this.yOff = yPos;
        this.anchor = anchor;
        this.sprites = sprites;
        this.icon = icon;
        this.hoverIcon = hoverIcon;
        this.action = action;
        this.text = text;
        this.hoverText = hoverText;
        this.active = active;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.hoverMessage = Component.translatable((String)(hoverText.isPresent() ? hoverText.get().key() : text.key()));
    }

    public int getXPos() {
        return this.xOff;
    }

    public int getYPos() {
        return this.yOff;
    }

    public AnchorPoint getAnchor() {
        return this.anchor;
    }

    public WidgetSprites getSprites() {
        return this.sprites;
    }

    public ButtonIcon getIcon() {
        return this.icon;
    }

    public Optional<ButtonIcon> getHoverIcon() {
        return this.hoverIcon;
    }

    public ButtonAction getAction() {
        return this.action;
    }

    public ButtonText getText() {
        return this.text;
    }

    public Optional<ButtonText> getHoverText() {
        return this.hoverText;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public JsonButton setup(ExtendedMenuScreen screen) {
        this.setX(this.xOff + this.anchor.getX(screen));
        this.setY(this.yOff + this.anchor.getY(screen));
        this.setMessage((Component)Component.translatable((String)this.text.key()));
        this.hoverMessage = Component.translatable((String)(this.hoverText.isPresent() ? this.hoverText.get().key() : this.text.key()));
        return this;
    }

    public Component getMessage() {
        if (this.isHoveredOrFocused()) {
            return this.hoverMessage;
        }
        return super.getMessage();
    }

    public void renderWidget(GuiGraphics gfx, int mouseX, int mouseY, float partial) {
        if (this.visible) {
            gfx.setColor(1.0f, 1.0f, 1.0f, this.alpha);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            gfx.pose().pushPose();
            gfx.pose().scale(this.scaleX, this.scaleY, 1.0f);
            gfx.blitSprite(this.sprites.get(this.active, this.isHoveredOrFocused()), Math.round((float)this.getX() / this.scaleX), Math.round((float)this.getY() / this.scaleY), Math.round((float)this.width / this.scaleX), Math.round((float)this.height / this.scaleY));
            ButtonIcon icon = this.getActiveIcon();
            if (icon != ButtonIcon.EMPTY) {
                int iconX = this.getX() + this.getWidth() / 2 - icon.width() / 2 + icon.xOff();
                int iconY = this.getY() + this.getHeight() / 2 - icon.height() / 2 + icon.yOff();
                gfx.blitSprite(icon.texture(), Math.round((float)iconX / this.scaleX), Math.round((float)iconY / this.scaleY), Math.round((float)icon.width() / this.scaleX), Math.round((float)icon.height() / this.scaleY));
            }
            gfx.pose().popPose();
            gfx.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            this.renderText(gfx, partial);
        }
    }

    protected void renderText(GuiGraphics stack, float partial) {
        Minecraft mc = Minecraft.getInstance();
        ButtonText text = this.getActiveText();
        Object msg = I18n.get((String)text.key(), (Object[])new Object[0]);
        int strWidth = mc.font.width((String)msg);
        if (strWidth <= this.width - 6) {
            int x = this.getX() + this.width / 2 - mc.font.width((String)msg) / 2 + text.xOff();
            int n = this.getY() + this.height / 2;
            Objects.requireNonNull(mc.font);
            int y = n - 9 / 2 + text.yOff();
            stack.drawString(mc.font, (String)msg, x, y, text.color(), text.dropShadow());
        } else if (!this.isHoveredOrFocused()) {
            this.scrollCounter = 0;
            int ellipsisWidth = mc.font.width("...");
            msg = JsonButton.trimStringToWidth(FormattedText.of((String)msg), this.width - 6 - ellipsisWidth).getString().trim() + "...";
            int x = this.getX() + this.width / 2 - mc.font.width((String)msg) / 2 + text.xOff();
            int n = this.getY() + this.height / 2;
            Objects.requireNonNull(mc.font);
            int y = n - 9 / 2 + text.yOff();
            stack.drawString(mc.font, (String)msg, x, y, text.color(), text.dropShadow());
        } else {
            Object origMsg = msg;
            int halfLen = mc.font.width((String)msg + MESSAGE_SEPARATOR);
            msg = (String)msg + MESSAGE_SEPARATOR + (String)msg;
            stack.pose().pushPose();
            double gScale = mc.getWindow().getGuiScale();
            float scissorY = Minecraft.getInstance().screen.height - this.getY() - this.height;
            RenderSystem.enableScissor((int)((int)((double)this.getX() * gScale)), (int)((int)((double)scissorY * gScale)), (int)((int)(gScale * (double)this.width)), (int)((int)(gScale * (double)this.height)));
            stack.pose().translate(((float)(-this.scrollCounter) - partial) % (float)halfLen, 0.0f, 0.0f);
            int ellipsisWidth = mc.font.width("...");
            origMsg = JsonButton.trimStringToWidth(FormattedText.of((String)msg), this.width - 6 - ellipsisWidth).getString().trim() + "...";
            int baseWidth = mc.font.width((String)origMsg);
            int x = this.getX() + this.width / 2 - baseWidth / 2 + text.xOff();
            int n = this.getY() + this.height / 2;
            Objects.requireNonNull(mc.font);
            int y = n - 9 / 2 + text.yOff();
            stack.drawString(mc.font, (String)msg, x, y, text.color(), text.dropShadow());
            RenderSystem.disableScissor();
            stack.pose().popPose();
        }
    }

    public void tickScrollCounter() {
        ++this.scrollCounter;
    }

    public ButtonText getActiveText() {
        if (this.isHoveredOrFocused()) {
            return this.hoverText.orElse(this.text);
        }
        return this.text;
    }

    public ButtonIcon getActiveIcon() {
        if (this.isHoveredOrFocused()) {
            return this.hoverIcon.orElse(this.icon);
        }
        return this.icon;
    }

    public static FormattedText trimStringToWidth(FormattedText str, int width) {
        return (FormattedText)Minecraft.getInstance().font.getSplitter().splitLines(str, width, Style.EMPTY).get(0);
    }

    protected static void drawCenteredString(GuiGraphics stack, Font font, String string, int x, int y, int color, boolean dropShadow) {
        stack.drawString(font, string, x - font.width(string) / 2, y, color, dropShadow);
    }
}

