/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cel.model;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.cotrin8672.cel.model.ProfileKey;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 #2\u00020\u0001:\u0002\"#B\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001aJ\u000e\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0013\u0010\u001f\u001a\u00020\u000e2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010!\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000fR\u001b\u0010\u0013\u001a\u00020\u00148FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lio/github/cotrin8672/cel/model/StorageFrequency;", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "profileKey", "Lio/github/cotrin8672/cel/model/ProfileKey;", "<init>", "(Lnet/minecraft/world/item/ItemStack;Lio/github/cotrin8672/cel/model/ProfileKey;)V", "getStack", "()Lnet/minecraft/world/item/ItemStack;", "getProfileKey", "()Lio/github/cotrin8672/cel/model/ProfileKey;", "copy", "isGlobalScope", "", "()Z", "isPersonalScope", "isEmpty", "isNotEmpty", "color", "", "getColor", "()I", "color$delegate", "Lkotlin/Lazy;", "save", "Lnet/minecraft/nbt/Tag;", "lookupProvider", "Lnet/minecraft/core/HolderLookup$Provider;", "tag", "saveOptional", "equals", "other", "hashCode", "FrequencyKey", "Companion", "createenderlink"})
public final class StorageFrequency {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ItemStack stack;
    @NotNull
    private final ProfileKey profileKey;
    @NotNull
    private final Lazy color$delegate;
    @NotNull
    private static final Lazy<ProfileKey> GLOBAL_PROFILE$delegate = LazyKt.lazy(StorageFrequency::GLOBAL_PROFILE_delegate$lambda$1);
    @NotNull
    private static final MapCodec<StorageFrequency> MAP_CODEC;
    @NotNull
    private static final Codec<StorageFrequency> CODEC;
    @NotNull
    private static final StreamCodec<RegistryFriendlyByteBuf, StorageFrequency> STREAM_CODEC;
    @NotNull
    private static final StorageFrequency EMPTY;
    @NotNull
    private static final ConcurrentHashMap<FrequencyKey, StorageFrequency> storageFrequencies;

    private StorageFrequency(ItemStack stack, ProfileKey profileKey) {
        this.stack = stack;
        this.profileKey = profileKey;
        this.color$delegate = LazyKt.lazy(() -> StorageFrequency.color_delegate$lambda$0(this));
    }

    /* synthetic */ StorageFrequency(ItemStack itemStack, ProfileKey profileKey, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            profileKey = Companion.getGLOBAL_PROFILE();
        }
        this(itemStack, profileKey);
    }

    @NotNull
    public final ItemStack getStack() {
        return this.stack;
    }

    @NotNull
    public final ProfileKey getProfileKey() {
        return this.profileKey;
    }

    @NotNull
    public final StorageFrequency copy(@NotNull ItemStack stack, @NotNull ProfileKey profileKey) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)profileKey, (String)"profileKey");
        return Companion.of(stack, profileKey);
    }

    public static /* synthetic */ StorageFrequency copy$default(StorageFrequency storageFrequency, ItemStack itemStack, ProfileKey profileKey, int n, Object object) {
        if ((n & 1) != 0) {
            itemStack = storageFrequency.stack;
        }
        if ((n & 2) != 0) {
            profileKey = storageFrequency.profileKey;
        }
        return storageFrequency.copy(itemStack, profileKey);
    }

    public final boolean isGlobalScope() {
        return Intrinsics.areEqual((Object)this.profileKey, (Object)Companion.getGLOBAL_PROFILE());
    }

    public final boolean isPersonalScope() {
        return !this.isGlobalScope();
    }

    public final boolean isEmpty() {
        return Intrinsics.areEqual((Object)this, (Object)EMPTY);
    }

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public final int getColor() {
        Lazy lazy = this.color$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @NotNull
    public final Tag save(@NotNull HolderLookup.Provider lookupProvider, @NotNull Tag tag) {
        Intrinsics.checkNotNullParameter((Object)lookupProvider, (String)"lookupProvider");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Optional optional = CODEC.encodeStart((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).resultOrPartial();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"resultOrPartial(...)");
        Object object = OptionalsKt.getOrDefault((Optional)optional, (Object)new CompoundTag());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrDefault(...)");
        return (Tag)object;
    }

    public static /* synthetic */ Tag save$default(StorageFrequency storageFrequency, HolderLookup.Provider provider, Tag tag, int n, Object object) {
        if ((n & 2) != 0) {
            tag = (Tag)new CompoundTag();
        }
        return storageFrequency.save(provider, tag);
    }

    @NotNull
    public final Tag saveOptional(@NotNull HolderLookup.Provider lookupProvider) {
        Intrinsics.checkNotNullParameter((Object)lookupProvider, (String)"lookupProvider");
        return this.isEmpty() ? (Tag)new CompoundTag() : this.save(lookupProvider, (Tag)new CompoundTag());
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof StorageFrequency)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.stack.getItem(), (Object)((StorageFrequency)other).stack.getItem()) && Intrinsics.areEqual((Object)this.profileKey, (Object)((StorageFrequency)other).profileKey) && this.getColor() == ((StorageFrequency)other).getColor();
    }

    public int hashCode() {
        return 31 * this.stack.getItem().hashCode() + this.profileKey.hashCode() ^ this.getColor();
    }

    private static final int color_delegate$lambda$0(StorageFrequency this$0) {
        DyedItemColor dyedItemColor = (DyedItemColor)this$0.stack.get(DataComponents.DYED_COLOR);
        return dyedItemColor != null ? dyedItemColor.rgb() : -1;
    }

    private static final ProfileKey GLOBAL_PROFILE_delegate$lambda$1() {
        UUID uUID = UUID.fromString("83695eeb-3b18-40d8-a790-d16d749e1413");
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
        return new ProfileKey(uUID, "Global");
    }

    private static final ItemStack MAP_CODEC$lambda$4$lambda$2(StorageFrequency it) {
        return it.stack;
    }

    private static final ProfileKey MAP_CODEC$lambda$4$lambda$3(StorageFrequency it) {
        return it.profileKey;
    }

    private static final App MAP_CODEC$lambda$4(RecordCodecBuilder.Instance builder) {
        return builder.group((App)ItemStack.OPTIONAL_CODEC.fieldOf("frequency_item").forGetter(StorageFrequency::MAP_CODEC$lambda$4$lambda$2), (App)ProfileKey.Companion.getCODEC().fieldOf("profile_key").forGetter(StorageFrequency::MAP_CODEC$lambda$4$lambda$3)).apply((Applicative)builder, (p0$stack, p1$profileKey) -> new StorageFrequency((ItemStack)p0$stack, (ProfileKey)p1$profileKey));
    }

    private static final ItemStack STREAM_CODEC$lambda$5(StorageFrequency freq) {
        return freq.stack;
    }

    private static final ProfileKey STREAM_CODEC$lambda$6(StorageFrequency freq) {
        return freq.profileKey;
    }

    public /* synthetic */ StorageFrequency(ItemStack stack, ProfileKey profileKey, DefaultConstructorMarker $constructor_marker) {
        this(stack, profileKey);
    }

    static {
        MapCodec mapCodec = RecordCodecBuilder.mapCodec(StorageFrequency::MAP_CODEC$lambda$4);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"mapCodec(...)");
        MAP_CODEC = mapCodec;
        Codec codec = MAP_CODEC.codec();
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"codec(...)");
        CODEC = codec;
        StreamCodec streamCodec = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, StorageFrequency::STREAM_CODEC$lambda$5, ProfileKey.Companion.getSTREAM_CODEC(), StorageFrequency::STREAM_CODEC$lambda$6, Companion::of);
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"composite(...)");
        STREAM_CODEC = streamCodec;
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        EMPTY = new StorageFrequency(itemStack, null, 2, null);
        storageFrequencies = new ConcurrentHashMap();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u0005J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0016\u0010&\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\f0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\f0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/github/cotrin8672/cel/model/StorageFrequency$Companion;", "", "<init>", "()V", "GLOBAL_PROFILE", "Lio/github/cotrin8672/cel/model/ProfileKey;", "getGLOBAL_PROFILE", "()Lio/github/cotrin8672/cel/model/ProfileKey;", "GLOBAL_PROFILE$delegate", "Lkotlin/Lazy;", "MAP_CODEC", "Lcom/mojang/serialization/MapCodec;", "Lio/github/cotrin8672/cel/model/StorageFrequency;", "CODEC", "Lcom/mojang/serialization/Codec;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "EMPTY", "getEMPTY", "()Lio/github/cotrin8672/cel/model/StorageFrequency;", "storageFrequencies", "Ljava/util/concurrent/ConcurrentHashMap;", "Lio/github/cotrin8672/cel/model/StorageFrequency$FrequencyKey;", "of", "stack", "Lnet/minecraft/world/item/ItemStack;", "profileKey", "parse", "Ljava/util/Optional;", "lookupProvider", "Lnet/minecraft/core/HolderLookup$Provider;", "tag", "Lnet/minecraft/nbt/CompoundTag;", "parseOptional", "createenderlink"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProfileKey getGLOBAL_PROFILE() {
            Lazy lazy = GLOBAL_PROFILE$delegate;
            return (ProfileKey)lazy.getValue();
        }

        @NotNull
        public final Codec<StorageFrequency> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final StreamCodec<RegistryFriendlyByteBuf, StorageFrequency> getSTREAM_CODEC() {
            return STREAM_CODEC;
        }

        @NotNull
        public final StorageFrequency getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final StorageFrequency of(@NotNull ItemStack stack, @NotNull ProfileKey profileKey) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)profileKey, (String)"profileKey");
            DyedItemColor dyedItemColor = (DyedItemColor)stack.get(DataComponents.DYED_COLOR);
            int color = dyedItemColor != null ? dyedItemColor.rgb() : -1;
            ConcurrentHashMap concurrentHashMap = storageFrequencies;
            Item item = stack.getItem();
            Intrinsics.checkNotNullExpressionValue((Object)item, (String)"getItem(...)");
            StorageFrequency storageFrequency = concurrentHashMap.computeIfAbsent(new FrequencyKey(item, color, profileKey), arg_0 -> Companion.of$lambda$1(arg_0 -> Companion.of$lambda$0(stack, profileKey, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)storageFrequency, (String)"computeIfAbsent(...)");
            return storageFrequency;
        }

        public static /* synthetic */ StorageFrequency of$default(Companion companion, ItemStack itemStack, ProfileKey profileKey, int n, Object object) {
            if ((n & 2) != 0) {
                profileKey = companion.getGLOBAL_PROFILE();
            }
            return companion.of(itemStack, profileKey);
        }

        @NotNull
        public final Optional<StorageFrequency> parse(@NotNull HolderLookup.Provider lookupProvider, @NotNull CompoundTag tag) {
            Intrinsics.checkNotNullParameter((Object)lookupProvider, (String)"lookupProvider");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Optional optional = this.getCODEC().parse((DynamicOps)lookupProvider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial();
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"resultOrPartial(...)");
            return optional;
        }

        @NotNull
        public final StorageFrequency parseOptional(@NotNull HolderLookup.Provider lookupProvider, @NotNull CompoundTag tag) {
            StorageFrequency storageFrequency;
            Intrinsics.checkNotNullParameter((Object)lookupProvider, (String)"lookupProvider");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            if (tag.isEmpty()) {
                storageFrequency = this.getEMPTY();
            } else {
                StorageFrequency storageFrequency2 = this.parse(lookupProvider, tag).orElse(this.getEMPTY());
                Intrinsics.checkNotNullExpressionValue((Object)storageFrequency2, (String)"orElse(...)");
                storageFrequency = storageFrequency2;
            }
            return storageFrequency;
        }

        private static final StorageFrequency of$lambda$0(ItemStack $stack, ProfileKey $profileKey, FrequencyKey it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ItemStack itemStack = $stack.getItem().getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getDefaultInstance(...)");
            return new StorageFrequency(itemStack, $profileKey, null);
        }

        private static final StorageFrequency of$lambda$1(Function1 $tmp0, Object p0) {
            return (StorageFrequency)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lio/github/cotrin8672/cel/model/StorageFrequency$FrequencyKey;", "", "item", "Lnet/minecraft/world/item/Item;", "color", "", "profileKey", "Lio/github/cotrin8672/cel/model/ProfileKey;", "<init>", "(Lnet/minecraft/world/item/Item;ILio/github/cotrin8672/cel/model/ProfileKey;)V", "getItem", "()Lnet/minecraft/world/item/Item;", "getColor", "()I", "getProfileKey", "()Lio/github/cotrin8672/cel/model/ProfileKey;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "createenderlink"})
    public static final class FrequencyKey {
        @NotNull
        private final Item item;
        private final int color;
        @NotNull
        private final ProfileKey profileKey;

        public FrequencyKey(@NotNull Item item, int color, @NotNull ProfileKey profileKey) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)profileKey, (String)"profileKey");
            this.item = item;
            this.color = color;
            this.profileKey = profileKey;
        }

        public /* synthetic */ FrequencyKey(Item item, int n, ProfileKey profileKey, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                profileKey = Companion.getGLOBAL_PROFILE();
            }
            this(item, n, profileKey);
        }

        @NotNull
        public final Item getItem() {
            return this.item;
        }

        public final int getColor() {
            return this.color;
        }

        @NotNull
        public final ProfileKey getProfileKey() {
            return this.profileKey;
        }

        @NotNull
        public final Item component1() {
            return this.item;
        }

        public final int component2() {
            return this.color;
        }

        @NotNull
        public final ProfileKey component3() {
            return this.profileKey;
        }

        @NotNull
        public final FrequencyKey copy(@NotNull Item item, int color, @NotNull ProfileKey profileKey) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)profileKey, (String)"profileKey");
            return new FrequencyKey(item, color, profileKey);
        }

        public static /* synthetic */ FrequencyKey copy$default(FrequencyKey frequencyKey, Item item, int n, ProfileKey profileKey, int n2, Object object) {
            if ((n2 & 1) != 0) {
                item = frequencyKey.item;
            }
            if ((n2 & 2) != 0) {
                n = frequencyKey.color;
            }
            if ((n2 & 4) != 0) {
                profileKey = frequencyKey.profileKey;
            }
            return frequencyKey.copy(item, n, profileKey);
        }

        @NotNull
        public String toString() {
            return "FrequencyKey(item=" + this.item + ", color=" + this.color + ", profileKey=" + this.profileKey + ")";
        }

        public int hashCode() {
            int result2 = this.item.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.color);
            result2 = result2 * 31 + this.profileKey.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FrequencyKey)) {
                return false;
            }
            FrequencyKey frequencyKey = (FrequencyKey)other;
            if (!Intrinsics.areEqual((Object)this.item, (Object)frequencyKey.item)) {
                return false;
            }
            if (this.color != frequencyKey.color) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.profileKey, (Object)frequencyKey.profileKey);
        }
    }
}

