/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cel.content.storage;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorage;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.content.contraptions.Contraption;
import io.github.cotrin8672.cel.content.storage.SharedItemStackHandler;
import io.github.cotrin8672.cel.content.storage.SharedMountedItemStorage;
import io.github.cotrin8672.cel.model.StorageFrequency;
import io.github.cotrin8672.cel.registry.CelMountedStorageTypes;
import io.github.cotrin8672.cel.util.SharedStorageHandler;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J \u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J0\u0010\u001b\u001a\u00020\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J&\u0010$\u001a\u00020\u00142\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006,"}, d2={"Lio/github/cotrin8672/cel/content/storage/SharedMountedItemStorage;", "Lcom/simibubi/create/api/contraption/storage/item/MountedItemStorage;", "frequency", "Lio/github/cotrin8672/cel/model/StorageFrequency;", "<init>", "(Lio/github/cotrin8672/cel/model/StorageFrequency;)V", "sharedItemStackHandler", "Lio/github/cotrin8672/cel/content/storage/SharedItemStackHandler;", "getSharedItemStackHandler", "()Lio/github/cotrin8672/cel/content/storage/SharedItemStackHandler;", "sharedItemStackHandler$delegate", "Lkotlin/Lazy;", "getSlots", "", "getStackInSlot", "Lnet/minecraft/world/item/ItemStack;", "slot", "insertItem", "stack", "simulate", "", "extractItem", "amount", "getSlotLimit", "isItemValid", "setStackInSlot", "", "unmount", "level", "Lnet/minecraft/world/level/Level;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "pos", "Lnet/minecraft/core/BlockPos;", "be", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "handleInteraction", "player", "Lnet/minecraft/server/level/ServerPlayer;", "contraption", "Lcom/simibubi/create/content/contraptions/Contraption;", "info", "Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate$StructureBlockInfo;", "Companion", "createenderlink"})
public final class SharedMountedItemStorage
extends MountedItemStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StorageFrequency frequency;
    @NotNull
    private final Lazy sharedItemStackHandler$delegate;
    @NotNull
    private static final MapCodec<SharedMountedItemStorage> CODEC;

    public SharedMountedItemStorage(@NotNull StorageFrequency frequency) {
        Intrinsics.checkNotNullParameter((Object)frequency, (String)"frequency");
        super((MountedItemStorageType)CelMountedStorageTypes.INSTANCE.getSHARED_ITEM().get());
        this.frequency = frequency;
        this.sharedItemStackHandler$delegate = LazyKt.lazy(() -> SharedMountedItemStorage.sharedItemStackHandler_delegate$lambda$0(this));
    }

    private final SharedItemStackHandler getSharedItemStackHandler() {
        Lazy lazy = this.sharedItemStackHandler$delegate;
        return (SharedItemStackHandler)((Object)lazy.getValue());
    }

    public int getSlots() {
        return this.getSharedItemStackHandler().getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        ItemStack itemStack = this.getSharedItemStackHandler().getStackInSlot(slot);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInSlot(...)");
        return itemStack;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return this.getSharedItemStackHandler().insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.getSharedItemStackHandler().extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.getSharedItemStackHandler().getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return this.getSharedItemStackHandler().isItemValid(slot, stack);
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.getSharedItemStackHandler().setStackInSlot(slot, stack);
    }

    public void unmount(@Nullable Level level, @Nullable BlockState state, @Nullable BlockPos pos, @Nullable BlockEntity be) {
    }

    public boolean handleInteraction(@Nullable ServerPlayer player, @Nullable Contraption contraption, @Nullable StructureTemplate.StructureBlockInfo info) {
        return false;
    }

    private static final SharedItemStackHandler sharedItemStackHandler_delegate$lambda$0(SharedMountedItemStorage this$0) {
        SharedStorageHandler sharedStorageHandler = SharedStorageHandler.Companion.getInstance();
        Intrinsics.checkNotNull((Object)((Object)sharedStorageHandler));
        return sharedStorageHandler.getOrCreateSharedItemStorage(this$0.frequency);
    }

    private static final SharedMountedItemStorage CODEC$lambda$1(Function1 $tmp0, Object p0) {
        return (SharedMountedItemStorage)((Object)$tmp0.invoke(p0));
    }

    private static final StorageFrequency CODEC$lambda$2(SharedMountedItemStorage it) {
        return it.frequency;
    }

    private static final StorageFrequency CODEC$lambda$3(Function1 $tmp0, Object p0) {
        return (StorageFrequency)$tmp0.invoke(p0);
    }

    static {
        MapCodec mapCodec = StorageFrequency.Companion.getCODEC().xmap(arg_0 -> SharedMountedItemStorage.CODEC$lambda$1(Companion.CODEC.1.INSTANCE, arg_0), arg_0 -> SharedMountedItemStorage.CODEC$lambda$3(SharedMountedItemStorage::CODEC$lambda$2, arg_0)).fieldOf("value");
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"fieldOf(...)");
        CODEC = mapCodec;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lio/github/cotrin8672/cel/content/storage/SharedMountedItemStorage$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Lio/github/cotrin8672/cel/content/storage/SharedMountedItemStorage;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "createenderlink"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<SharedMountedItemStorage> getCODEC() {
            return CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

