/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cel.content.item;

import com.simibubi.create.AllKeys;
import io.github.cotrin8672.cel.content.item.ScopeFilterMenu;
import io.github.cotrin8672.cel.model.ProfileKey;
import io.github.cotrin8672.cel.model.StorageFrequency;
import io.github.cotrin8672.cel.registry.CelDataComponents;
import io.github.cotrin8672.cel.registry.CelItems;
import io.github.cotrin8672.cel.util.CelLang;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J.\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010#\u001a\u00020\u001aH\u0016\u00a8\u0006$"}, d2={"Lio/github/cotrin8672/cel/content/item/ScopeFilterItem;", "Lnet/minecraft/world/item/Item;", "Lnet/minecraft/world/MenuProvider;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "world", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "appendHoverText", "", "stack", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "id", "", "inv", "Lnet/minecraft/world/entity/player/Inventory;", "getDisplayName", "createenderlink"})
public final class ScopeFilterItem
extends Item
implements MenuProvider {
    public ScopeFilterItem(@NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Player player2 = player;
        Level level = context.getLevel();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
        InteractionHand interactionHand = context.getHand();
        Intrinsics.checkNotNullExpressionValue((Object)interactionHand, (String)"getHand(...)");
        InteractionResult interactionResult = this.use(level, player2, interactionHand).getResult();
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"getResult(...)");
        return interactionResult;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack heldItem = player.getItemInHand(hand);
        StorageFrequency oldStorageFrequency = (StorageFrequency)heldItem.get(CelDataComponents.INSTANCE.getSTORAGE_FREQUENCY());
        StorageFrequency storageFrequency = oldStorageFrequency;
        if (storageFrequency == null || (storageFrequency = storageFrequency.getStack()) == null) {
            storageFrequency = ItemStack.EMPTY;
        }
        StorageFrequency storageFrequency2 = storageFrequency;
        Intrinsics.checkNotNull((Object)storageFrequency2);
        UUID uUID = player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        String string = player.getName().getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        StorageFrequency storageFrequency3 = StorageFrequency.Companion.of((ItemStack)storageFrequency2, new ProfileKey(uUID, string));
        heldItem.set(CelDataComponents.INSTANCE.getSTORAGE_FREQUENCY(), (Object)storageFrequency3);
        if (!world.isClientSide && player instanceof ServerPlayer) {
            ((ServerPlayer)player).openMenu((MenuProvider)this, arg_0 -> ScopeFilterItem.use$lambda$0(heldItem, arg_0));
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)heldItem);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        if (AllKeys.shiftDown()) {
            return;
        }
        StorageFrequency storageFrequency = (StorageFrequency)stack.get(CelDataComponents.INSTANCE.getSTORAGE_FREQUENCY());
        Object object = storageFrequency;
        String frequencyOwnerName = object != null && (object = ((StorageFrequency)object).getProfileKey()) != null ? ((ProfileKey)object).name() : null;
        MutableComponent frequencyOwnerTip = CelLang.INSTANCE.translate("gui.goggles.frequency_scope", new Object[0]).add(frequencyOwnerName == null ? CelLang.INSTANCE.translate("gui.goggles.scope_global", new Object[0]).component() : Component.literal((String)frequencyOwnerName)).style(ChatFormatting.YELLOW).component();
        MutableComponent mutableComponent = Component.empty();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"empty(...)");
        tooltipComponents.add((Component)mutableComponent);
        Intrinsics.checkNotNull((Object)frequencyOwnerTip);
        tooltipComponents.add((Component)frequencyOwnerTip);
    }

    @NotNull
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inv, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)inv, (String)"inv");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ItemStack itemStack = player.getMainHandItem();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getMainHandItem(...)");
        return (AbstractContainerMenu)ScopeFilterMenu.Companion.create(id, inv, itemStack);
    }

    @NotNull
    public Component getDisplayName() {
        ItemStack itemStack = CelItems.INSTANCE.getSCOPE_FILTER().asStack();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"asStack(...)");
        MutableComponent mutableComponent = CelLang.INSTANCE.itemName(itemStack).component();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"component(...)");
        return (Component)mutableComponent;
    }

    private static final void use$lambda$0(ItemStack $heldItem, RegistryFriendlyByteBuf buf) {
        ItemStack.STREAM_CODEC.encode((Object)buf, (Object)$heldItem);
    }
}

