/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cel.content.block.vault;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import io.github.cotrin8672.cel.content.SharedStorageBehaviour;
import io.github.cotrin8672.cel.content.storage.SharedItemStackHandler;
import io.github.cotrin8672.cel.registry.CelBlockEntityTypes;
import io.github.cotrin8672.cel.registry.CelBlocks;
import io.github.cotrin8672.cel.util.LinkCountManager;
import io.github.cotrin8672.cel.util.SharedStorageHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB#\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u001e\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\fH\u0016J\b\u0010\u0019\u001a\u00020\fH\u0016J\b\u0010\u001a\u001a\u00020\fH\u0016\u00a8\u0006\u001c"}, d2={"Lio/github/cotrin8672/cel/content/block/vault/EnderVaultBlockEntity;", "Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;", "Lcom/simibubi/create/api/equipment/goggles/IHaveGoggleInformation;", "type", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "onLoad", "", "getInventory", "Lnet/neoforged/neoforge/items/IItemHandler;", "addBehaviours", "behaviours", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "addToGoggleTooltip", "", "tooltip", "Lnet/minecraft/network/chat/Component;", "isPlayerSneaking", "destroy", "remove", "onChunkUnloaded", "Companion", "createenderlink"})
public final class EnderVaultBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public EnderVaultBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
    }

    public void onLoad() {
        super.onLoad();
        if (this.level instanceof ServerLevel) {
            LinkCountManager.INSTANCE.registerEntity((ResourceKey<Block>)CelBlocks.INSTANCE.getENDER_VAULT().getKey(), this);
        }
    }

    private final IItemHandler getInventory() {
        SharedStorageBehaviour sharedStorageBehaviour = (SharedStorageBehaviour)this.getBehaviour(SharedStorageBehaviour.Companion.getTYPE());
        if (sharedStorageBehaviour == null) {
            return null;
        }
        SharedStorageBehaviour behaviour = sharedStorageBehaviour;
        Level level = this.level;
        if (level == null) {
            return null;
        }
        Level nonNullLevel = level;
        if (nonNullLevel instanceof ServerLevel) {
            SharedStorageHandler sharedStorageHandler = SharedStorageHandler.Companion.getInstance();
            SharedItemStackHandler inventory = sharedStorageHandler != null ? sharedStorageHandler.getOrCreateSharedItemStorage(behaviour.getFrequency()) : null;
            return (IItemHandler)inventory;
        }
        return null;
    }

    public void addBehaviours(@NotNull List<BlockEntityBehaviour> behaviours) {
        Intrinsics.checkNotNullParameter(behaviours, (String)"behaviours");
        behaviours.add(new SharedStorageBehaviour(this, (ValueBoxTransform)new CenteredSideValueBoxTransform(EnderVaultBlockEntity::addBehaviours$lambda$0)));
    }

    public boolean addToGoggleTooltip(@NotNull List<Component> tooltip, boolean isPlayerSneaking) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        ((SharedStorageBehaviour)this.getBehaviour(SharedStorageBehaviour.Companion.getTYPE())).addToGoggleTooltip(tooltip, isPlayerSneaking);
        return true;
    }

    public void destroy() {
        super.destroy();
        LinkCountManager.INSTANCE.unregisterEntity((ResourceKey<Block>)CelBlocks.INSTANCE.getENDER_VAULT().getKey(), this);
    }

    public void remove() {
        super.remove();
        LinkCountManager.INSTANCE.unregisterEntity((ResourceKey<Block>)CelBlocks.INSTANCE.getENDER_VAULT().getKey(), this);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        LinkCountManager.INSTANCE.unregisterEntity((ResourceKey<Block>)CelBlocks.INSTANCE.getENDER_VAULT().getKey(), this);
    }

    private static final boolean addBehaviours$lambda$0(BlockState state, Direction direction) {
        return state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS) == direction.getAxis();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lio/github/cotrin8672/cel/content/block/vault/EnderVaultBlockEntity$Companion;", "", "<init>", "()V", "registerCapabilities", "", "event", "Lnet/neoforged/neoforge/capabilities/RegisterCapabilitiesEvent;", "createenderlink"})
    public static final class Companion {
        private Companion() {
        }

        public final void registerCapabilities(@NotNull RegisterCapabilitiesEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)CelBlockEntityTypes.INSTANCE.getENDER_VAULT().get(), (arg_0, arg_1) -> Companion.registerCapabilities$lambda$1(Companion::registerCapabilities$lambda$0, arg_0, arg_1));
        }

        private static final IItemHandler registerCapabilities$lambda$0(EnderVaultBlockEntity be, Direction direction) {
            return be.getInventory();
        }

        private static final IItemHandler registerCapabilities$lambda$1(Function2 $tmp0, Object p0, Direction p1) {
            return (IItemHandler)$tmp0.invoke(p0, (Object)p1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

