/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cel.content.block.vault;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import io.github.cotrin8672.cel.content.SharedStorageBehaviour;
import io.github.cotrin8672.cel.content.block.vault.EnderVaultBlockEntity;
import io.github.cotrin8672.cel.model.StorageFrequency;
import io.github.cotrin8672.cel.registry.CelBlockEntityTypes;
import io.github.cotrin8672.cel.registry.CelBlocks;
import io.github.cotrin8672.cel.registry.CelDataComponents;
import io.github.cotrin8672.cel.util.CelLang;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 22\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003:\u00012B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\u00020\n2\u0016\u0010\u000b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\r0\fH\u0014J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fH\u0016J\u0010\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J@\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0014J2\u0010*\u001a\u00020\n2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0013\u001a\u00020\r2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J0\u0010-\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010.\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010/\u001a\u00020\r2\u0006\u00100\u001a\u000201H\u0016\u00a8\u00063"}, d2={"Lio/github/cotrin8672/cel/content/block/vault/EnderVaultBlock;", "Lnet/minecraft/world/level/block/Block;", "Lcom/simibubi/create/content/equipment/wrench/IWrenchable;", "Lcom/simibubi/create/foundation/block/IBE;", "Lio/github/cotrin8672/cel/content/block/vault/EnderVaultBlockEntity;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/state/BlockState;", "getBlockEntityClass", "Ljava/lang/Class;", "getBlockEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "rotate", "state", "rot", "Lnet/minecraft/world/level/block/Rotation;", "mirror", "mirrorIn", "Lnet/minecraft/world/level/block/Mirror;", "getStateForPlacement", "context", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "useItemOn", "Lnet/minecraft/world/ItemInteractionResult;", "stack", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "setPlacedBy", "placer", "Lnet/minecraft/world/entity/LivingEntity;", "onRemove", "worldIn", "newState", "isMoving", "", "Companion", "createenderlink"})
public final class EnderVaultBlock
extends Block
implements IWrenchable,
IBE<EnderVaultBlockEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EnumProperty<Direction.Axis> HORIZONTAL_AXIS;

    public EnderVaultBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{HORIZONTAL_AXIS};
        super.createBlockStateDefinition(builder.add(propertyArray));
    }

    @NotNull
    public Class<EnderVaultBlockEntity> getBlockEntityClass() {
        return EnderVaultBlockEntity.class;
    }

    @NotNull
    public BlockEntityType<? extends EnderVaultBlockEntity> getBlockEntityType() {
        Object object = CelBlockEntityTypes.INSTANCE.getENDER_VAULT().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (BlockEntityType)object;
    }

    @NotNull
    protected BlockState rotate(@NotNull BlockState state, @NotNull Rotation rot) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)rot, (String)"rot");
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)HORIZONTAL_AXIS);
        Direction rotatedDir = rot.rotate(Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
        Object object = state.setValue((Property)HORIZONTAL_AXIS, (Comparable)rotatedDir.getAxis());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    @NotNull
    protected BlockState mirror(@NotNull BlockState state, @NotNull Mirror mirrorIn) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)mirrorIn, (String)"mirrorIn");
        return state;
    }

    @NotNull
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = this.defaultBlockState().setValue((Property)HORIZONTAL_AXIS, (Comparable)context.getHorizontalDirection().getAxis());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        ItemStack heldItem = player.getItemInHand(hand);
        if (CelBlocks.INSTANCE.getENDER_VAULT().isIn(heldItem)) {
            this.withBlockEntityDo((BlockGetter)level, pos, arg_0 -> EnderVaultBlock.useItemOn$lambda$0(heldItem, arg_0));
            if (player instanceof ServerPlayer) {
                ((ServerPlayer)player).displayClientMessage((Component)CelLang.INSTANCE.translate("storage_frequency.set", new Object[0]).component(), true);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        super.setPlacedBy(level, pos, state, placer, stack);
        StorageFrequency storageFrequency = (StorageFrequency)stack.getOrDefault(CelDataComponents.INSTANCE.getSTORAGE_FREQUENCY(), (Object)StorageFrequency.Companion.getEMPTY());
        if (storageFrequency.isNotEmpty()) {
            this.withBlockEntityDo((BlockGetter)level, pos, arg_0 -> EnderVaultBlock.setPlacedBy$lambda$1(storageFrequency, arg_0));
        }
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        IBE.onRemove((BlockState)state, (Level)worldIn, (BlockPos)pos, (BlockState)newState);
    }

    private static final void useItemOn$lambda$0(ItemStack $heldItem, EnderVaultBlockEntity it) {
        StorageFrequency storageFrequency = ((SharedStorageBehaviour)it.getBehaviour(SharedStorageBehaviour.Companion.getTYPE())).getFrequency();
        StorageFrequency storageFrequency2 = storageFrequency.isEmpty() ? (StorageFrequency)$heldItem.remove(CelDataComponents.INSTANCE.getSTORAGE_FREQUENCY()) : (StorageFrequency)$heldItem.set(CelDataComponents.INSTANCE.getSTORAGE_FREQUENCY(), (Object)storageFrequency);
    }

    private static final void setPlacedBy$lambda$1(StorageFrequency $storageFrequency, EnderVaultBlockEntity it) {
        SharedStorageBehaviour behaviour = (SharedStorageBehaviour)it.getBehaviour(SharedStorageBehaviour.Companion.getTYPE());
        Intrinsics.checkNotNull((Object)$storageFrequency);
        behaviour.setStorageFrequency($storageFrequency);
    }

    static {
        EnumProperty enumProperty = BlockStateProperties.HORIZONTAL_AXIS;
        Intrinsics.checkNotNullExpressionValue((Object)enumProperty, (String)"HORIZONTAL_AXIS");
        HORIZONTAL_AXIS = enumProperty;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lio/github/cotrin8672/cel/content/block/vault/EnderVaultBlock$Companion;", "", "<init>", "()V", "HORIZONTAL_AXIS", "Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "Lnet/minecraft/core/Direction$Axis;", "getHORIZONTAL_AXIS", "()Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "createenderlink"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EnumProperty<Direction.Axis> getHORIZONTAL_AXIS() {
            return HORIZONTAL_AXIS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

