/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cel.content.block.tank;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import io.github.cotrin8672.cel.content.SharedStorageBehaviour;
import io.github.cotrin8672.cel.content.storage.SharedFluidTank;
import io.github.cotrin8672.cel.model.StorageFrequency;
import io.github.cotrin8672.cel.registry.CelBlockEntityTypes;
import io.github.cotrin8672.cel.registry.CelBlocks;
import io.github.cotrin8672.cel.util.LinkCountManager;
import io.github.cotrin8672.cel.util.SharedStorageHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.ponder.api.level.PonderLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B#\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0011J\u0016\u0010\u0015\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\u001a\u001a\u00020\u0013H\u0016J\u001e\u0010\u001b\u001a\u00020\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00172\u0006\u0010\u001e\u001a\u00020\u000eH\u0016J\b\u0010\u001f\u001a\u00020\u0013H\u0016J\b\u0010 \u001a\u00020\u0013H\u0016J\b\u0010!\u001a\u00020\u0013H\u0016J\b\u0010\"\u001a\u00020\u0013H\u0016J \u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000eH\u0014J \u0010)\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000eH\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lio/github/cotrin8672/cel/content/block/tank/EnderTankBlockEntity;", "Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;", "Lcom/simibubi/create/api/equipment/goggles/IHaveGoggleInformation;", "type", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "luminosity", "", "queuedSync", "", "syncCooldown", "ponderTank", "Lio/github/cotrin8672/cel/content/storage/SharedFluidTank;", "onLoad", "", "getFluidTank", "addBehaviours", "behaviours", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "setLuminosity", "tick", "addToGoggleTooltip", "tooltip", "Lnet/minecraft/network/chat/Component;", "isPlayerSneaking", "destroy", "remove", "onChunkUnloaded", "sendData", "read", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "clientPacket", "write", "Companion", "createenderlink"})
public final class EnderTankBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int luminosity;
    private boolean queuedSync;
    private int syncCooldown;
    @Nullable
    private SharedFluidTank ponderTank;

    public EnderTankBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
    }

    public void onLoad() {
        super.onLoad();
        if (this.level instanceof ServerLevel) {
            LinkCountManager.INSTANCE.registerEntity((ResourceKey<Block>)CelBlocks.INSTANCE.getENDER_TANK().getKey(), this);
        }
    }

    @Nullable
    public final SharedFluidTank getFluidTank() {
        if (this.level instanceof PonderLevel) {
            if (this.ponderTank == null) {
                this.ponderTank = new SharedFluidTank(10000, null, StorageFrequency.Companion.getEMPTY());
            }
            return this.ponderTank;
        }
        SharedStorageBehaviour sharedStorageBehaviour = (SharedStorageBehaviour)this.getBehaviour(SharedStorageBehaviour.Companion.getTYPE());
        if (sharedStorageBehaviour == null) {
            return null;
        }
        SharedStorageBehaviour behaviour = sharedStorageBehaviour;
        SharedStorageHandler sharedStorageHandler = SharedStorageHandler.Companion.getInstance();
        SharedFluidTank fluidTank = sharedStorageHandler != null ? sharedStorageHandler.getOrCreateSharedFluidStorage(behaviour.getFrequency()) : null;
        return fluidTank;
    }

    public void addBehaviours(@NotNull List<BlockEntityBehaviour> behaviours) {
        Intrinsics.checkNotNullParameter(behaviours, (String)"behaviours");
        behaviours.add(new SharedStorageBehaviour(this, (ValueBoxTransform)new CenteredSideValueBoxTransform(EnderTankBlockEntity::addBehaviours$lambda$0)));
    }

    public final void setLuminosity(int luminosity) {
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        if (level.isClientSide) {
            return;
        }
        if (this.luminosity == luminosity) {
            return;
        }
        this.luminosity = luminosity;
        this.sendData();
    }

    public void tick() {
        super.tick();
        if (this.syncCooldown > 0) {
            int n = this.syncCooldown;
            this.syncCooldown = n + -1;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
    }

    public boolean addToGoggleTooltip(@NotNull List<Component> tooltip, boolean isPlayerSneaking) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        Level level = this.level;
        this.containedFluidTooltip(tooltip, isPlayerSneaking, level != null ? (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, this.getBlockPos(), (Object)Direction.UP) : null);
        Component component = CommonComponents.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"EMPTY");
        tooltip.add(component);
        ((SharedStorageBehaviour)this.getBehaviour(SharedStorageBehaviour.Companion.getTYPE())).addToGoggleTooltip(tooltip, isPlayerSneaking);
        return true;
    }

    public void destroy() {
        super.destroy();
        LinkCountManager.INSTANCE.unregisterEntity((ResourceKey<Block>)CelBlocks.INSTANCE.getENDER_TANK().getKey(), this);
    }

    public void remove() {
        super.remove();
        LinkCountManager.INSTANCE.unregisterEntity((ResourceKey<Block>)CelBlocks.INSTANCE.getENDER_TANK().getKey(), this);
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        LinkCountManager.INSTANCE.unregisterEntity((ResourceKey<Block>)CelBlocks.INSTANCE.getENDER_TANK().getKey(), this);
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    protected void read(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries, boolean clientPacket) {
        block0: {
            Level level;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
            super.read(tag, registries, clientPacket);
            int prevLum = this.luminosity;
            this.luminosity = tag.getInt("Luminosity");
            if (this.luminosity == prevLum || !this.hasLevel() || (level = this.level) == null || (level = level.getChunkSource()) == null || (level = level.getLightEngine()) == null) break block0;
            level.checkBlock(this.worldPosition);
        }
    }

    protected void write(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        tag.putInt("Luminosity", this.luminosity);
        super.write(tag, registries, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.queuedSync) {
            tag.putBoolean("LazySync", true);
        }
    }

    private static final boolean addBehaviours$lambda$0(BlockState blockState, Direction direction) {
        return direction.getAxis() == Direction.Axis.Y;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lio/github/cotrin8672/cel/content/block/tank/EnderTankBlockEntity$Companion;", "", "<init>", "()V", "registerCapability", "", "event", "Lnet/neoforged/neoforge/capabilities/RegisterCapabilitiesEvent;", "createenderlink"})
    public static final class Companion {
        private Companion() {
        }

        public final void registerCapability(@NotNull RegisterCapabilitiesEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CelBlockEntityTypes.INSTANCE.getENDER_TANK().get(), (arg_0, arg_1) -> Companion.registerCapability$lambda$1(Companion::registerCapability$lambda$0, arg_0, arg_1));
        }

        private static final IFluidHandler registerCapability$lambda$0(EnderTankBlockEntity be, Direction direction) {
            return (IFluidHandler)be.getFluidTank();
        }

        private static final IFluidHandler registerCapability$lambda$1(Function2 $tmp0, Object p0, Direction p1) {
            return (IFluidHandler)$tmp0.invoke(p0, (Object)p1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

