/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cel.content.block.tank;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.fluid.FluidHelper;
import io.github.cotrin8672.cel.content.SharedStorageBehaviour;
import io.github.cotrin8672.cel.content.block.tank.EnderTankBlockEntity;
import io.github.cotrin8672.cel.content.storage.SharedFluidTank;
import io.github.cotrin8672.cel.model.StorageFrequency;
import io.github.cotrin8672.cel.registry.CelBlockEntityTypes;
import io.github.cotrin8672.cel.registry.CelBlocks;
import io.github.cotrin8672.cel.registry.CelDataComponents;
import io.github.cotrin8672.cel.util.CelLang;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u0016J\u0010\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\fH\u0016J@\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J2\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J0\u0010!\u001a\u00020\u001e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%H\u0016\u00a8\u0006&"}, d2={"Lio/github/cotrin8672/cel/content/block/tank/EnderTankBlock;", "Lnet/minecraft/world/level/block/Block;", "Lcom/simibubi/create/content/equipment/wrench/IWrenchable;", "Lcom/simibubi/create/foundation/block/IBE;", "Lio/github/cotrin8672/cel/content/block/tank/EnderTankBlockEntity;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getBlockEntityClass", "Ljava/lang/Class;", "getBlockEntityType", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "useItemOn", "Lnet/minecraft/world/ItemInteractionResult;", "stack", "Lnet/minecraft/world/item/ItemStack;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "setPlacedBy", "", "placer", "Lnet/minecraft/world/entity/LivingEntity;", "onRemove", "worldIn", "newState", "isMoving", "", "createenderlink"})
public final class EnderTankBlock
extends Block
implements IWrenchable,
IBE<EnderTankBlockEntity> {
    public EnderTankBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    @NotNull
    public Class<EnderTankBlockEntity> getBlockEntityClass() {
        return EnderTankBlockEntity.class;
    }

    @NotNull
    public BlockEntityType<? extends EnderTankBlockEntity> getBlockEntityType() {
        Object object = CelBlockEntityTypes.INSTANCE.getENDER_TANK().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (BlockEntityType)object;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        block6: {
            SoundEvent sound;
            boolean didTransfer;
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
            Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
            ItemStack heldItem = player.getItemInHand(hand);
            if (CelBlocks.INSTANCE.getENDER_TANK().isIn(heldItem)) {
                this.withBlockEntityDo((BlockGetter)level, pos, arg_0 -> EnderTankBlock.useItemOn$lambda$0(heldItem, arg_0));
                if (player instanceof ServerPlayer) {
                    ((ServerPlayer)player).displayClientMessage((Component)CelLang.INSTANCE.translate("storage_frequency.set", new Object[0]).component(), true);
                }
                return ItemInteractionResult.SUCCESS;
            }
            BlockEntity blockEntity = level.getBlockEntity(pos);
            EnderTankBlockEntity enderTankBlockEntity = blockEntity instanceof EnderTankBlockEntity ? (EnderTankBlockEntity)blockEntity : null;
            if (enderTankBlockEntity == null) {
                return ItemInteractionResult.FAIL;
            }
            EnderTankBlockEntity be = enderTankBlockEntity;
            SharedFluidTank sharedFluidTank = be.getFluidTank();
            if (sharedFluidTank == null) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            SharedFluidTank tank = sharedFluidTank;
            FluidStack prev = tank.getFluidInTank(0).copy();
            boolean bl = FluidHelper.tryEmptyItemIntoBE((Level)level, (Player)player, (InteractionHand)hand, (ItemStack)stack, (SmartBlockEntity)be) ? true : (didTransfer = FluidHelper.tryFillItemFromBE((Level)level, (Player)player, (InteractionHand)hand, (ItemStack)stack, (SmartBlockEntity)be));
            if (!didTransfer) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (level.isClientSide) break block6;
            FluidStack current = tank.getFluidInTank(0);
            SoundEvent soundEvent = sound = current.getAmount() > prev.getAmount() ? FluidHelper.getEmptySound((FluidStack)current) : (current.getAmount() < prev.getAmount() ? FluidHelper.getFillSound((FluidStack)prev) : null);
            if (soundEvent != null) {
                SoundEvent it = soundEvent;
                boolean bl2 = false;
                level.playSound(null, pos, it, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void setPlacedBy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        super.setPlacedBy(level, pos, state, placer, stack);
        StorageFrequency storageFrequency = (StorageFrequency)stack.getOrDefault(CelDataComponents.INSTANCE.getSTORAGE_FREQUENCY(), (Object)StorageFrequency.Companion.getEMPTY());
        if (storageFrequency.isNotEmpty()) {
            this.withBlockEntityDo((BlockGetter)level, pos, arg_0 -> EnderTankBlock.setPlacedBy$lambda$2(storageFrequency, arg_0));
        }
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        IBE.onRemove((BlockState)state, (Level)worldIn, (BlockPos)pos, (BlockState)newState);
    }

    private static final void useItemOn$lambda$0(ItemStack $heldItem, EnderTankBlockEntity it) {
        StorageFrequency storageFrequency = ((SharedStorageBehaviour)it.getBehaviour(SharedStorageBehaviour.Companion.getTYPE())).getFrequency();
        StorageFrequency storageFrequency2 = storageFrequency.isEmpty() ? (StorageFrequency)$heldItem.remove(CelDataComponents.INSTANCE.getSTORAGE_FREQUENCY()) : (StorageFrequency)$heldItem.set(CelDataComponents.INSTANCE.getSTORAGE_FREQUENCY(), (Object)storageFrequency);
    }

    private static final void setPlacedBy$lambda$2(StorageFrequency $storageFrequency, EnderTankBlockEntity it) {
        SharedStorageBehaviour behaviour = (SharedStorageBehaviour)it.getBehaviour(SharedStorageBehaviour.Companion.getTYPE());
        Intrinsics.checkNotNull((Object)$storageFrequency);
        behaviour.setStorageFrequency($storageFrequency);
    }
}

