/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cel.content.block;

import com.tterrag.registrate.util.entry.ItemEntry;
import io.github.cotrin8672.cel.model.StorageFrequency;
import io.github.cotrin8672.cel.network.SyncFullLinkPacket;
import io.github.cotrin8672.cel.registry.CelDataComponents;
import io.github.cotrin8672.cel.registry.CelItems;
import io.github.cotrin8672.cel.util.CelLang;
import io.github.cotrin8672.cel.util.InventoryExtensionKt;
import io.github.cotrin8672.cel.util.LinkCountManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J0\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lio/github/cotrin8672/cel/content/block/SharedStorageBlockItem;", "Lnet/minecraft/world/item/BlockItem;", "block", "Lnet/minecraft/world/level/block/Block;", "properties", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/level/block/Block;Lnet/minecraft/world/item/Item$Properties;)V", "isFoil", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "place", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "appendHoverText", "", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "createenderlink"})
public final class SharedStorageBlockItem
extends BlockItem {
    public SharedStorageBlockItem(@NotNull Block block, @NotNull Item.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(block, properties);
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        StorageFrequency storageFrequency = (StorageFrequency)stack.getOrDefault(CelDataComponents.INSTANCE.getSTORAGE_FREQUENCY(), (Object)StorageFrequency.Companion.getEMPTY());
        return storageFrequency.isNotEmpty();
    }

    @NotNull
    public InteractionResult place(@NotNull BlockPlaceContext context) {
        InteractionResult result2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Player player = context.getPlayer();
        ItemStack heldItem = context.getItemInHand();
        StorageFrequency storageFrequency = (StorageFrequency)heldItem.getOrDefault(CelDataComponents.INSTANCE.getSTORAGE_FREQUENCY(), (Object)StorageFrequency.Companion.getEMPTY());
        if (player == null) {
            v0 = storageFrequency.isGlobalScope() ? super.place(context) : InteractionResult.FAIL;
        } else if (storageFrequency.isGlobalScope()) {
            v0 = super.place(context);
        } else if (player.isCreative()) {
            v0 = super.place(context);
        } else {
            Inventory inventory = player.getInventory();
            Intrinsics.checkNotNullExpressionValue((Object)inventory, (String)"getInventory(...)");
            if (InventoryExtensionKt.consumeItem(inventory, 1, (Function1<? super ItemStack, Boolean>)((Function1)new Function1<ItemStack, Boolean>(CelItems.INSTANCE.getSCOPE_FILTER()){

                public final Boolean invoke(ItemStack p0) {
                    return ((ItemEntry)this.receiver).isIn(p0);
                }
            }))) {
                v0 = super.place(context);
            } else {
                player.displayClientMessage((Component)CelLang.INSTANCE.translate("storage_frequency.not_holding_enough_scope_filter", new Object[0]).style(ChatFormatting.RED).component(), true);
                v0 = result2 = InteractionResult.FAIL;
            }
        }
        if (context.getLevel() instanceof ServerLevel) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncFullLinkPacket(LinkCountManager.INSTANCE.getLinkedList()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        Intrinsics.checkNotNull((Object)result2);
        return result2;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        StorageFrequency storageFrequency = (StorageFrequency)stack.getOrDefault(CelDataComponents.INSTANCE.getSTORAGE_FREQUENCY(), (Object)StorageFrequency.Companion.getEMPTY());
        if (storageFrequency.isNotEmpty()) {
            CelLang.INSTANCE.translate("storage_frequency.is_set", new Object[0]).style(ChatFormatting.GOLD).addTo(tooltipComponents);
            CelLang.INSTANCE.translate("storage_frequency.craft_to_reset", new Object[0]).style(ChatFormatting.GRAY).addTo(tooltipComponents);
        }
    }
}

