/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cel.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxRenderer;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import io.github.cotrin8672.cel.content.SharedStorageBehaviour;
import io.github.cotrin8672.cel.model.StorageFrequency;
import io.github.cotrin8672.cel.registry.CelItems;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.outliner.Outline;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.render.BindableTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import thedarkcolour.kotlinforforge.neoforge.forge.PoseStackUtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ6\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J,\u0010\u0016\u001a\u00020\t*\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lio/github/cotrin8672/cel/client/FrequencyRenderer;", "", "<init>", "()V", "scopeFilter", "Lnet/minecraft/world/item/ItemStack;", "kotlin.jvm.PlatformType", "Lnet/minecraft/world/item/ItemStack;", "tick", "", "renderOnBlockEntity", "be", "Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;", "partialTicks", "", "ms", "Lcom/mojang/blaze3d/vertex/PoseStack;", "buffer", "Lnet/minecraft/client/renderer/MultiBufferSource;", "light", "", "overlay", "renderFrequencyItem", "frequency", "Lio/github/cotrin8672/cel/model/StorageFrequency;", "createenderlink"})
@SourceDebugExtension(value={"SMAP\nFrequencyRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrequencyRenderer.kt\nio/github/cotrin8672/cel/client/FrequencyRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1#2:177\n*E\n"})
public final class FrequencyRenderer {
    @NotNull
    public static final FrequencyRenderer INSTANCE = new FrequencyRenderer();
    private static final ItemStack scopeFilter = CelItems.INSTANCE.getSCOPE_FILTER().asStack();

    private FrequencyRenderer() {
    }

    public final void tick() {
        Minecraft mc = Minecraft.getInstance();
        HitResult target = mc.hitResult;
        if (target == null || !(target instanceof BlockHitResult)) {
            return;
        }
        ClientLevel clientLevel = mc.level;
        if (clientLevel == null) {
            return;
        }
        ClientLevel level = clientLevel;
        BlockPos pos = ((BlockHitResult)target).getBlockPos();
        BlockState state = level.getBlockState(pos);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        LocalPlayer localPlayer = mc.player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        if (player.isShiftKeyDown()) {
            return;
        }
        if (!(blockEntity instanceof SmartBlockEntity)) {
            return;
        }
        for (BlockEntityBehaviour behaviour : ((SmartBlockEntity)blockEntity).getAllBehaviours()) {
            ArrayList<MutableComponent> arrayList;
            ValueBox.ItemValueBox itemValueBox;
            if (!(behaviour instanceof SharedStorageBehaviour)) continue;
            if (((SharedStorageBehaviour)behaviour).getSlotPositioning() instanceof ValueBoxTransform.Sided) {
                ValueBoxTransform valueBoxTransform = ((SharedStorageBehaviour)behaviour).getSlotPositioning();
                Intrinsics.checkNotNull((Object)valueBoxTransform, (String)"null cannot be cast to non-null type com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform.Sided");
                ((ValueBoxTransform.Sided)valueBoxTransform).fromSide(((BlockHitResult)target).getDirection());
            }
            if (!((SharedStorageBehaviour)behaviour).getSlotPositioning().shouldRender((LevelAccessor)level, pos, state)) continue;
            ItemStack frequencyItem = ((SharedStorageBehaviour)behaviour).getFrequency().getStack();
            boolean hit = ((SharedStorageBehaviour)behaviour).getSlotPositioning().testHit((LevelAccessor)level, pos, state, ((BlockHitResult)target).getLocation().subtract(Vec3.atLowerCornerOf((Vec3i)((Vec3i)pos))));
            AABB emptyBB = new AABB(Vec3.ZERO, Vec3.ZERO);
            AABB bb = emptyBB.inflate(0.25);
            ValueBox.ItemValueBox $this$tick_u24lambda_u240 = itemValueBox = new ValueBox.ItemValueBox((Component)((SharedStorageBehaviour)behaviour).getLabel(), bb, pos, frequencyItem, Component.empty());
            boolean bl = false;
            $this$tick_u24lambda_u240.passive(!hit);
            ValueBox.ItemValueBox box = itemValueBox;
            Outliner.getInstance().showOutline((Object)Pair.of((Object)"frequency1", (Object)pos), (Outline)box.transform(((SharedStorageBehaviour)behaviour).getSlotPositioning())).lineWidth(0.015625f).withFaceTexture((BindableTexture)(hit ? AllSpecialTextures.THIN_CHECKERED : null)).highlightFace(((BlockHitResult)target).getDirection());
            if (!hit) continue;
            ArrayList<MutableComponent> $this$tick_u24lambda_u241 = arrayList = new ArrayList<MutableComponent>();
            boolean bl2 = false;
            $this$tick_u24lambda_u241.add(((SharedStorageBehaviour)behaviour).getLabel().copy());
            $this$tick_u24lambda_u241.add(((SharedStorageBehaviour)behaviour).getTip().copy());
            ArrayList<MutableComponent> tip = arrayList;
            CreateClient.VALUE_SETTINGS_HANDLER.showHoverTip((List)tip);
        }
    }

    public final void renderOnBlockEntity(@NotNull SmartBlockEntity be, float partialTicks, @NotNull PoseStack ms, @NotNull MultiBufferSource buffer, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)be, (String)"be");
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (be.isRemoved()) {
            return;
        }
        Level level = be.getLevel();
        if (level == null) {
            return;
        }
        Level level2 = level;
        BlockPos blockPos = be.getBlockPos();
        for (BlockEntityBehaviour behaviour : be.getAllBehaviours()) {
            Entity cameraEntity;
            if (!(behaviour instanceof SharedStorageBehaviour)) continue;
            if (!be.isVirtual() && (cameraEntity = Minecraft.getInstance().cameraEntity) != null && Intrinsics.areEqual((Object)level2, (Object)cameraEntity.level())) {
                float max = ((SharedStorageBehaviour)behaviour).getRenderDistance();
                if (cameraEntity.position().distanceToSqr(VecHelper.getCenterOf((Vec3i)((Vec3i)blockPos))) > (double)(max * max)) continue;
            }
            if (!((SharedStorageBehaviour)behaviour).isActive() || ((SharedStorageBehaviour)behaviour).getFrequency().getStack().isEmpty() && ((SharedStorageBehaviour)behaviour).getFrequency().isGlobalScope()) continue;
            ValueBoxTransform slotPositioning = ((SharedStorageBehaviour)behaviour).getSlotPositioning();
            BlockState blockState = be.getBlockState();
            if (slotPositioning instanceof ValueBoxTransform.Sided) {
                Direction side = ((ValueBoxTransform.Sided)slotPositioning).getSide();
                Iterator iterator = ArrayIteratorKt.iterator((Object[])Iterate.directions);
                while (iterator.hasNext()) {
                    Direction direction = (Direction)iterator.next();
                    StorageFrequency frequency = ((SharedStorageBehaviour)behaviour).getFrequency();
                    if (frequency.getStack().isEmpty() && ((SharedStorageBehaviour)behaviour).getFrequency().isGlobalScope()) continue;
                    ((ValueBoxTransform.Sided)slotPositioning).fromSide(direction);
                    if (!((ValueBoxTransform.Sided)slotPositioning).shouldRender((LevelAccessor)level2, blockPos, blockState)) continue;
                    PoseStackUtilKt.use((PoseStack)ms, () -> FrequencyRenderer.renderOnBlockEntity$lambda$2(slotPositioning, level2, blockPos, blockState, ms, frequency, buffer, light, overlay));
                }
                ((ValueBoxTransform.Sided)slotPositioning).fromSide(side);
                continue;
            }
            if (!slotPositioning.shouldRender((LevelAccessor)level2, blockPos, blockState)) continue;
            PoseStackUtilKt.use((PoseStack)ms, () -> FrequencyRenderer.renderOnBlockEntity$lambda$3(slotPositioning, level2, blockPos, blockState, ms, behaviour, buffer, light, overlay));
        }
    }

    private final void renderFrequencyItem(PoseStack $this$renderFrequencyItem, StorageFrequency frequency, MultiBufferSource buffer, int light, int overlay) {
        ItemStack frequencyItem = frequency.getStack();
        if (frequency.isPersonalScope()) {
            Minecraft mc = Minecraft.getInstance();
            ItemRenderer itemRenderer = mc.getItemRenderer();
            BakedModel modelWithOverrides = itemRenderer.getModel(frequencyItem, null, null, 0);
            boolean blockItem = modelWithOverrides.isGui3d();
            float factor = blockItem ? 1.25f : 1.0f;
            float scale = 1.75f * factor;
            PoseStackUtilKt.use((PoseStack)$this$renderFrequencyItem, () -> FrequencyRenderer.renderFrequencyItem$lambda$4($this$renderFrequencyItem, scale, buffer, light, overlay));
            PoseStackUtilKt.use((PoseStack)$this$renderFrequencyItem, () -> FrequencyRenderer.renderFrequencyItem$lambda$5($this$renderFrequencyItem, frequencyItem, buffer, light, overlay));
        } else {
            PoseStackUtilKt.use((PoseStack)$this$renderFrequencyItem, () -> FrequencyRenderer.renderFrequencyItem$lambda$6(frequencyItem, $this$renderFrequencyItem, buffer, light, overlay));
        }
    }

    private static final Unit renderOnBlockEntity$lambda$2(ValueBoxTransform $slotPositioning, Level $level, BlockPos $blockPos, BlockState $blockState, PoseStack $ms, StorageFrequency $frequency, MultiBufferSource $buffer, int $light, int $overlay) {
        $slotPositioning.transform((LevelAccessor)$level, $blockPos, $blockState, $ms);
        if (AllBlocks.CONTRAPTION_CONTROLS.has($blockState)) {
            ValueBoxRenderer.renderFlatItemIntoValueBox((ItemStack)$frequency.getStack(), (PoseStack)$ms, (MultiBufferSource)$buffer, (int)$light, (int)$overlay);
        } else {
            INSTANCE.renderFrequencyItem($ms, $frequency, $buffer, $light, $overlay);
        }
        return Unit.INSTANCE;
    }

    private static final Unit renderOnBlockEntity$lambda$3(ValueBoxTransform $slotPositioning, Level $level, BlockPos $blockPos, BlockState $blockState, PoseStack $ms, BlockEntityBehaviour $behaviour, MultiBufferSource $buffer, int $light, int $overlay) {
        $slotPositioning.transform((LevelAccessor)$level, $blockPos, $blockState, $ms);
        INSTANCE.renderFrequencyItem($ms, ((SharedStorageBehaviour)$behaviour).getFrequency(), $buffer, $light, $overlay);
        return Unit.INSTANCE;
    }

    private static final Unit renderFrequencyItem$lambda$4(PoseStack $this_renderFrequencyItem, float $scale, MultiBufferSource $buffer, int $light, int $overlay) {
        $this_renderFrequencyItem.scale($scale, $scale, 1.0f);
        ValueBoxRenderer.renderItemIntoValueBox((ItemStack)scopeFilter, (PoseStack)$this_renderFrequencyItem, (MultiBufferSource)$buffer, (int)$light, (int)$overlay);
        return Unit.INSTANCE;
    }

    private static final Unit renderFrequencyItem$lambda$5(PoseStack $this_renderFrequencyItem, ItemStack $frequencyItem, MultiBufferSource $buffer, int $light, int $overlay) {
        $this_renderFrequencyItem.translate(0.0f, 0.0f, -0.01f);
        ValueBoxRenderer.renderItemIntoValueBox((ItemStack)$frequencyItem, (PoseStack)$this_renderFrequencyItem, (MultiBufferSource)$buffer, (int)$light, (int)$overlay);
        return Unit.INSTANCE;
    }

    private static final Unit renderFrequencyItem$lambda$6(ItemStack $frequencyItem, PoseStack $this_renderFrequencyItem, MultiBufferSource $buffer, int $light, int $overlay) {
        ValueBoxRenderer.renderItemIntoValueBox((ItemStack)$frequencyItem, (PoseStack)$this_renderFrequencyItem, (MultiBufferSource)$buffer, (int)$light, (int)$overlay);
        return Unit.INSTANCE;
    }
}

