/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.network.server;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.manager.crafting.MachineStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SUpdateCraftingStatusPacket(MachineStatus status, BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SUpdateCraftingStatusPacket> TYPE = new CustomPacketPayload.Type(ModularMachineryReborn.rl("update_crafting_status"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SUpdateCraftingStatusPacket> CODEC = StreamCodec.composite((StreamCodec)NeoForgeStreamCodecs.enumCodec(MachineStatus.class), SUpdateCraftingStatusPacket::status, (StreamCodec)BlockPos.STREAM_CODEC, SUpdateCraftingStatusPacket::pos, SUpdateCraftingStatusPacket::new);

    public CustomPacketPayload.Type<SUpdateCraftingStatusPacket> type() {
        return TYPE;
    }

    public static void handle(SUpdateCraftingStatusPacket packet, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> {
                MachineControllerEntity machineTile;
                BlockEntity tile;
                if (Minecraft.getInstance().level != null && (tile = Minecraft.getInstance().level.getBlockEntity(packet.pos)) instanceof MachineControllerEntity && packet.status != (machineTile = (MachineControllerEntity)tile).getStatus()) {
                    machineTile.setStatus(packet.status);
                    machineTile.refreshClientData();
                    Minecraft.getInstance().level.sendBlockUpdated(packet.pos, tile.getBlockState(), tile.getBlockState(), 3);
                }
            });
        }
    }
}

