/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.machine.component;

import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.MachineComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.util.HybridTank;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidComponent
extends MachineComponent<HybridTank> {
    private final HybridTank handler;

    public FluidComponent(HybridTank handler, IOType ioType) {
        super(ioType);
        this.handler = handler;
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentRegistration.COMPONENT_FLUID.get();
    }

    @Override
    public HybridTank getContainerProvider() {
        return this.handler;
    }

    @Override
    public <C extends MachineComponent<?>> boolean canMerge(C c) {
        FluidComponent comp = (FluidComponent)c;
        if (this.getIOType().isInput()) {
            return this.handler.getFluid().is(comp.handler.getFluid().getFluid());
        }
        return this.handler.isEmpty() || comp.handler.isEmpty() || this.handler.getFluid().is(comp.handler.getFluid().getFluid());
    }

    @Override
    public <C extends MachineComponent<?>> C merge(C c) {
        final FluidComponent comp = (FluidComponent)c;
        return (C)new FluidComponent(new HybridTank(this.handler.getCapacity() + comp.handler.getCapacity()){

            public FluidStack getFluid() {
                FluidStack one = FluidComponent.this.handler.getFluid();
                FluidStack second = comp.getContainerProvider().getFluid();
                if (!one.isEmpty()) {
                    return one;
                }
                if (!second.isEmpty()) {
                    return second;
                }
                return FluidStack.EMPTY;
            }

            public int getFluidAmount() {
                int one = FluidComponent.this.handler.getFluidAmount();
                int second = comp.handler.getFluidAmount();
                return one + second;
            }

            public boolean isFluidValid(FluidStack stack) {
                return FluidComponent.this.handler.isFluidValid(stack) || comp.handler.isFluidValid(stack);
            }

            public void setFluid(FluidStack stack) {
            }

            public boolean isEmpty() {
                return FluidComponent.this.handler.isEmpty() && comp.handler.isEmpty();
            }

            public int getSpace() {
                return FluidComponent.this.handler.getSpace() + comp.handler.getSpace();
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                int filled1 = FluidComponent.this.handler.fill(resource, action);
                resource = resource.copyWithAmount(resource.getAmount() - filled1);
                int filled2 = comp.handler.fill(resource, action);
                return filled1 + filled2;
            }

            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                FluidStack drained1 = FluidComponent.this.handler.drain(resource, action);
                FluidStack drained2 = comp.handler.drain(resource = resource.copyWithAmount(resource.getAmount() - drained1.getAmount()), action);
                return drained2.isEmpty() ? drained1 : resource.copyWithAmount(drained1.getAmount() + drained2.getAmount());
            }

            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                FluidStack drained1 = FluidComponent.this.handler.drain(maxDrain, action);
                FluidStack drained2 = FluidComponent.this.handler.drain(maxDrain -= drained1.getAmount(), action);
                return drained1.copyWithAmount(drained1.getAmount() + drained2.getAmount());
            }
        }, this.getIOType());
    }

    @Override
    public int compareTo(MachineComponent<HybridTank> o) {
        HybridTank one = this.getContainerProvider();
        HybridTank two = o.getContainerProvider();
        if (one.isEmpty() && two.isEmpty()) {
            return 0;
        }
        if (one.isEmpty() && !two.isEmpty()) {
            return -1;
        }
        if (!one.isEmpty() && !two.isEmpty()) {
            return 0;
        }
        return 1;
    }
}

