/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.machine.component;

import es.degrassi.experiencelib.api.capability.IExperienceHandler;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.MachineComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import org.jetbrains.annotations.NotNull;

public class ExperienceComponent
extends MachineComponent<IExperienceHandler> {
    private final IExperienceHandler handler;

    public ExperienceComponent(IExperienceHandler handler, IOType ioType) {
        super(ioType);
        this.handler = handler;
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentRegistration.COMPONENT_EXPERIENCE.get();
    }

    @Override
    @NotNull
    public IExperienceHandler getContainerProvider() {
        return this.handler;
    }

    @Override
    public <C extends MachineComponent<?>> C merge(C c) {
        final ExperienceComponent comp = (ExperienceComponent)c;
        return (C)new ExperienceComponent(new IExperienceHandler(){

            public boolean canAcceptExperience(long l) {
                return true;
            }

            public boolean canProvideExperience(long l) {
                return true;
            }

            public long getMaxExtract() {
                return Math.max(ExperienceComponent.this.handler.getMaxExtract(), comp.handler.getMaxExtract());
            }

            public long getMaxReceive() {
                return Math.max(ExperienceComponent.this.handler.getMaxReceive(), comp.handler.getMaxReceive());
            }

            public long getExperience() {
                return ExperienceComponent.this.handler.getExperience() + comp.handler.getExperience();
            }

            public long getExperienceCapacity() {
                return ExperienceComponent.this.handler.getExperienceCapacity() + comp.handler.getExperienceCapacity();
            }

            public void setExperience(long l) {
            }

            public void setCapacity(long l) {
            }

            public long receiveExperience(long l, boolean b) {
                long received1 = ExperienceComponent.this.handler.receiveExperience(l, b);
                long received2 = comp.handler.receiveExperience(l -= received1, b);
                return received1 + received2;
            }

            public long extractExperience(long l, boolean b) {
                long extracted1 = ExperienceComponent.this.handler.extractExperience(l, b);
                long extracted2 = comp.handler.extractExperience(l -= extracted1, b);
                return extracted1 + extracted2;
            }

            public long extractExperienceRecipe(long l, boolean b) {
                long extracted1 = ExperienceComponent.this.handler.extractExperienceRecipe(l, b);
                long extracted2 = comp.handler.extractExperienceRecipe(l -= extracted1, b);
                return extracted1 + extracted2;
            }

            public long receiveExperienceRecipe(long l, boolean b) {
                long received1 = ExperienceComponent.this.handler.receiveExperienceRecipe(l, b);
                long received2 = comp.handler.receiveExperienceRecipe(l -= received1, b);
                return received1 + received2;
            }
        }, this.getIOType());
    }
}

