/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.machine;

import com.google.gson.JsonObject;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.manager.crafting.MachineStatus;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MachineComponent<T>
implements Comparable<MachineComponent<T>> {
    private final IOType ioType;

    public MachineComponent(IOType ioType) {
        this.ioType = ioType;
    }

    public final IOType getIOType() {
        return this.ioType;
    }

    public abstract ComponentType getComponentType();

    @Nullable
    public abstract T getContainerProvider();

    public void onStatusChanged(MachineStatus oldStatus, MachineStatus newStatus, Component errorMessage) {
    }

    public JsonObject asJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getComponentType().getId().toString());
        json.addProperty("mode", this.getIOType().getSerializedName());
        return json;
    }

    public CompoundTag asTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putString("type", this.getComponentType().getId().toString());
        tag.putString("mode", this.getIOType().getSerializedName());
        return tag;
    }

    public String toString() {
        return this.asJson().toString();
    }

    public abstract <C extends MachineComponent<?>> C merge(C var1);

    public <C extends MachineComponent<?>> boolean canMerge(C c) {
        return c.getIOType().equals((Object)this.getIOType());
    }

    @Override
    public int compareTo(@NotNull MachineComponent<T> o) {
        return 0;
    }
}

