/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.integration.theoneprobe;

import es.degrassi.mmreborn.ModularMachineryReborn;
import es.degrassi.mmreborn.common.crafting.helper.CraftingStatus;
import es.degrassi.mmreborn.common.entity.MachineControllerEntity;
import es.degrassi.mmreborn.common.integration.theoneprobe.element.CustomProgress;
import es.degrassi.mmreborn.common.manager.crafting.MachineProcessorCore;
import java.util.function.Function;
import mcjty.theoneprobe.api.IElementFactory;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TOPInfoProvider
implements IProbeInfoProvider,
Function<ITheOneProbe, Void> {
    @Override
    public Void apply(ITheOneProbe probe) {
        probe.registerProvider((IProbeInfoProvider)this);
        probe.registerElementFactory((IElementFactory)new CustomProgress.CustomProgressFactory());
        return null;
    }

    public ResourceLocation getID() {
        return ModularMachineryReborn.rl("mmr_info_provider");
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo info, Player player, Level level, BlockState state, IProbeHitData data) {
        BlockEntity tile = level.getBlockEntity(data.getPos());
        if (tile instanceof MachineControllerEntity) {
            MachineControllerEntity controller = (MachineControllerEntity)tile;
            if (controller.isPaused()) {
                info.mcText((Component)Component.translatable((String)"gui.controller.status.paused").withStyle(ChatFormatting.DARK_RED));
                return;
            }
            this.showCraftingInfo(controller, info);
        }
    }

    private void showCraftingInfo(MachineControllerEntity tile, IProbeInfo info) {
        CraftingStatus status = tile.getCraftingStatus();
        MutableComponent message = status.getUnlocMessage().copy();
        switch (status.getStatus()) {
            case CRAFTING: {
                message.withStyle(ChatFormatting.GREEN);
                break;
            }
            case NO_RECIPE: {
                message.withStyle(ChatFormatting.GOLD);
                break;
            }
            case MISSING_STRUCTURE: 
            case FAILURE: {
                message.withStyle(ChatFormatting.RED);
            }
        }
        info.mcText((Component)message);
        long runningCores = tile.getProcessor().cores().stream().filter(MachineProcessorCore::isActive).filter(MachineProcessorCore::hasActiveRecipe).count();
        MutableComponent component = Component.translatable((String)"mmr.waila.cores", (Object[])new Object[]{runningCores});
        info.mcText((Component)component);
    }
}

