/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.entity.base;

import es.degrassi.mmreborn.common.util.IEntitySynchronizable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockEntitySynchronized
extends BlockEntity
implements IEntitySynchronizable {
    private static final String REQUEST_UPDATE_KEY = "requestModelUpdate";
    private static final String IN_STRUCTURE_KEY = "inStructure";
    private boolean requestModelUpdate = false;
    private boolean inStructure = false;

    public BlockEntitySynchronized(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    @Override
    public void tick() {
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.requestModelUpdate = nbt.contains(REQUEST_UPDATE_KEY) && nbt.getBoolean(REQUEST_UPDATE_KEY);
        this.inStructure = nbt.contains(IN_STRUCTURE_KEY) && nbt.getBoolean(IN_STRUCTURE_KEY);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.saveAdditional(nbt, pRegistries);
        nbt.putBoolean(REQUEST_UPDATE_KEY, this.requestModelUpdate);
        nbt.putBoolean(IN_STRUCTURE_KEY, this.inStructure);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag nbt = super.getUpdateTag(pRegistries);
        this.saveAdditional(nbt, pRegistries);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    @Override
    public void markForUpdate() {
        if (this.requestModelUpdate) {
            this.requestModelDataUpdate();
        }
        this.setRequestModelUpdate(false);
        this.getLevel().setBlockAndUpdate(this.getBlockPos(), this.getBlockState());
        this.setChanged();
    }

    @Generated
    public boolean isRequestModelUpdate() {
        return this.requestModelUpdate;
    }

    @Generated
    public boolean isInStructure() {
        return this.inStructure;
    }

    @Generated
    public void setRequestModelUpdate(boolean requestModelUpdate) {
        this.requestModelUpdate = requestModelUpdate;
    }

    @Generated
    public void setInStructure(boolean inStructure) {
        this.inStructure = inStructure;
    }
}

