/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.crafting.requirement;

import com.mojang.datafixers.kinds.Applicative;
import es.degrassi.mmreborn.api.codec.NamedCodec;
import es.degrassi.mmreborn.api.crafting.CraftingResult;
import es.degrassi.mmreborn.api.crafting.ICraftingContext;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirement;
import es.degrassi.mmreborn.api.crafting.requirement.IRequirementList;
import es.degrassi.mmreborn.common.crafting.ComponentType;
import es.degrassi.mmreborn.common.crafting.requirement.PositionedRequirement;
import es.degrassi.mmreborn.common.crafting.requirement.RequirementType;
import es.degrassi.mmreborn.common.machine.IOType;
import es.degrassi.mmreborn.common.machine.component.HeightComponent;
import es.degrassi.mmreborn.common.registration.ComponentRegistration;
import es.degrassi.mmreborn.common.registration.RequirementTypeRegistration;
import es.degrassi.mmreborn.common.util.IntRange;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class RequirementHeight
implements IRequirement<HeightComponent> {
    public static final NamedCodec<RequirementHeight> CODEC = NamedCodec.record(instance -> instance.group(IntRange.CODEC.fieldOf("range").forGetter(RequirementHeight::height), PositionedRequirement.POSITION_CODEC.optionalFieldOf("position", new PositionedRequirement(0, 0)).forGetter(IRequirement::getPosition)).apply((Applicative)instance, RequirementHeight::new), "Height Requirement");
    private final IntRange height;
    private final PositionedRequirement position;

    public RequirementHeight(IntRange height, PositionedRequirement position) {
        this.height = height;
        this.position = position;
    }

    public IntRange height() {
        return this.height;
    }

    @Override
    public RequirementType<RequirementHeight> getType() {
        return RequirementTypeRegistration.HEIGHT.get();
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentRegistration.COMPONENT_HEIGHT.get();
    }

    @Override
    public IOType getMode() {
        return IOType.INPUT;
    }

    @Override
    public boolean test(HeightComponent component, ICraftingContext context) {
        return this.height.contains(context.getMachineTile().getBlockPos().getY());
    }

    @Override
    public void gatherRequirements(IRequirementList<HeightComponent> list) {
        list.worldCondition(this::check);
    }

    private CraftingResult check(HeightComponent component, ICraftingContext context) {
        int height = context.getMachineTile().getBlockPos().getY();
        if (this.height.contains(height)) {
            return CraftingResult.success();
        }
        return CraftingResult.error((Component)Component.translatable((String)"craftcheck.failure.height", (Object[])new Object[]{this.height.toFormattedString(), height}));
    }

    @Override
    @NotNull
    public Component getMissingComponentErrorMessage(IOType ioType) {
        return Component.translatable((String)"component.missing.height");
    }

    @Override
    public boolean isComponentValid(HeightComponent m, ICraftingContext context) {
        return this.getMode().equals((Object)m.getIOType());
    }

    @Override
    @Generated
    public PositionedRequirement getPosition() {
        return this.position;
    }
}

