/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.block.prop;

import es.degrassi.mmreborn.common.block.prop.ConfigLoaded;
import java.util.Locale;
import net.minecraft.util.StringRepresentable;

public enum EnergyHatchSize implements StringRepresentable,
ConfigLoaded
{
    TINY(2048, 128),
    SMALL(4096, 512),
    NORMAL(8192, 512),
    REINFORCED(16384, 2048),
    BIG(32768, 8192),
    HUGE(131072, 32768),
    LUDICROUS(524288, 131072),
    ULTIMATE(0x200000, 131072);

    public long maxEnergy;
    public long transferLimit;
    public final int defaultConfigurationEnergy;
    public final int defaultConfigurationTransferLimit;

    public static EnergyHatchSize value(String value) {
        return switch (value.toUpperCase(Locale.ROOT)) {
            case "SMALL" -> SMALL;
            case "NORMAL" -> NORMAL;
            case "REINFORCED" -> REINFORCED;
            case "BIG" -> BIG;
            case "HUGE" -> HUGE;
            case "LUDICROUS" -> LUDICROUS;
            case "ULTIMATE" -> ULTIMATE;
            default -> TINY;
        };
    }

    private EnergyHatchSize(int maxEnergy, int transferLimit) {
        this.defaultConfigurationEnergy = maxEnergy;
        this.defaultConfigurationTransferLimit = transferLimit;
    }

    public String getSerializedName() {
        return this.name().toLowerCase();
    }
}

