/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.common.block;

import es.degrassi.mmreborn.client.util.EnergyDisplayUtil;
import es.degrassi.mmreborn.common.block.BlockEnergyHatch;
import es.degrassi.mmreborn.common.block.prop.EnergyHatchSize;
import es.degrassi.mmreborn.common.entity.EnergyInputHatchEntity;
import es.degrassi.mmreborn.common.item.EnergyHatchItem;
import es.degrassi.mmreborn.common.registration.ItemRegistration;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BlockEnergyInputHatch
extends BlockEnergyHatch {
    public BlockEnergyInputHatch(EnergyHatchSize type) {
        super(type);
    }

    @Override
    @NotNull
    protected List<ItemStack> getDrops(@NotNull BlockState state, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder builder) {
        List<ItemStack> drops = super.getDrops(state, builder);
        switch (this.type) {
            case TINY: {
                drops.add(((EnergyHatchItem)ItemRegistration.ENERGY_INPUT_HATCH_TINY.get()).getDefaultInstance());
                break;
            }
            case SMALL: {
                drops.add(((EnergyHatchItem)ItemRegistration.ENERGY_INPUT_HATCH_SMALL.get()).getDefaultInstance());
                break;
            }
            case NORMAL: {
                drops.add(((EnergyHatchItem)ItemRegistration.ENERGY_INPUT_HATCH_NORMAL.get()).getDefaultInstance());
                break;
            }
            case REINFORCED: {
                drops.add(((EnergyHatchItem)ItemRegistration.ENERGY_INPUT_HATCH_REINFORCED.get()).getDefaultInstance());
                break;
            }
            case BIG: {
                drops.add(((EnergyHatchItem)ItemRegistration.ENERGY_INPUT_HATCH_BIG.get()).getDefaultInstance());
                break;
            }
            case HUGE: {
                drops.add(((EnergyHatchItem)ItemRegistration.ENERGY_INPUT_HATCH_HUGE.get()).getDefaultInstance());
                break;
            }
            case LUDICROUS: {
                drops.add(((EnergyHatchItem)ItemRegistration.ENERGY_INPUT_HATCH_LUDICROUS.get()).getDefaultInstance());
                break;
            }
            case ULTIMATE: {
                drops.add(((EnergyHatchItem)ItemRegistration.ENERGY_INPUT_HATCH_ULTIMATE.get()).getDefaultInstance());
            }
        }
        return drops;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, List<Component> tooltip, TooltipFlag flag) {
        if (EnergyDisplayUtil.displayFETooltip) {
            tooltip.add((Component)Component.translatable((String)"tooltip.energyhatch.storage", (Object[])new Object[]{this.type.maxEnergy}).withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"tooltip.energyhatch.in.accept", (Object[])new Object[]{this.type.transferLimit}).withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.empty());
        }
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new EnergyInputHatchEntity(pos, state, this.type);
    }
}

