/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.client.requirement;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.api.stack.FluidEmiStack;
import dev.emi.emi.platform.EmiAgnos;
import es.degrassi.mmreborn.common.crafting.requirement.emi.Position;
import es.degrassi.mmreborn.common.crafting.requirement.emi.StackHolder;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.level.material.Fluid;

public interface FluidRendering
extends StackHolder,
Position {
    default public void renderFluid(GuiGraphics graphics) {
        graphics.pose().pushPose();
        Object object = this.getStack().getKey();
        if (object instanceof Fluid) {
            Fluid fluid = (Fluid)object;
            FluidEmiStack fes = new FluidEmiStack(fluid, this.getStack().getComponentChanges(), this.getStack().getAmount());
            boolean floaty = EmiAgnos.isFloatyFluid((FluidEmiStack)fes);
            int x = 1;
            int y = 1;
            int w = this.getWidth();
            int h = this.getHeight();
            int filledHeight = Math.max(1, (int)Math.min((long)h, fes.getAmount() * (long)h / this.getStack().getAmount()));
            int sy = floaty ? y : y + h;
            for (int oy = 0; oy < filledHeight; oy += 16) {
                int rh = Math.min(16, filledHeight - oy);
                for (int ox = 0; ox < w; ox += 16) {
                    int rw = Math.min(16, w - ox);
                    if (floaty) {
                        EmiAgnos.renderFluid((FluidEmiStack)fes, (PoseStack)graphics.pose(), (int)(x + ox), (int)(sy + oy), (float)0.0f, (int)0, (int)0, (int)rw, (int)rh);
                        continue;
                    }
                    EmiAgnos.renderFluid((FluidEmiStack)fes, (PoseStack)graphics.pose(), (int)(x + ox), (int)(sy + (oy + rh) * -1), (float)0.0f, (int)0, (int)(16 - rh), (int)rw, (int)rh);
                }
            }
        }
        graphics.pose().popPose();
    }
}

