/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.api.network.syncable;

import es.degrassi.mmreborn.api.network.AbstractSyncable;
import es.degrassi.mmreborn.api.network.data.NbtData;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;

public abstract class NbtSyncable
extends AbstractSyncable<NbtData, CompoundTag> {
    @Override
    public NbtData getData(short id) {
        return new NbtData(id, (CompoundTag)this.get());
    }

    @Override
    public boolean needSync() {
        CompoundTag value = (CompoundTag)this.get();
        boolean needSync = this.lastKnownValue != null ? !value.equals(this.lastKnownValue) : true;
        this.lastKnownValue = value.copy();
        return needSync;
    }

    public static NbtSyncable create(final Supplier<CompoundTag> supplier, final Consumer<CompoundTag> consumer) {
        return new NbtSyncable(){

            @Override
            public CompoundTag get() {
                return (CompoundTag)supplier.get();
            }

            @Override
            public void set(CompoundTag value) {
                consumer.accept(value);
            }
        };
    }
}

