/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.mmreborn.api.network.syncable;

import es.degrassi.mmreborn.api.network.AbstractSyncable;
import es.degrassi.mmreborn.api.network.data.ItemStackData;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;

public abstract class ItemStackSyncable
extends AbstractSyncable<ItemStackData, ItemStack> {
    @Override
    public ItemStackData getData(short id) {
        return new ItemStackData(id, (ItemStack)this.get());
    }

    @Override
    public boolean needSync() {
        ItemStack value = (ItemStack)this.get();
        boolean needSync = this.lastKnownValue != null ? !ItemStack.matches((ItemStack)value, (ItemStack)((ItemStack)this.lastKnownValue)) : true;
        this.lastKnownValue = value.copy();
        return needSync;
    }

    public static ItemStackSyncable create(final Supplier<ItemStack> supplier, final Consumer<ItemStack> consumer) {
        return new ItemStackSyncable(){

            @Override
            public ItemStack get() {
                return (ItemStack)supplier.get();
            }

            @Override
            public void set(ItemStack value) {
                consumer.accept(value);
            }
        };
    }
}

