/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.core;

import eu.midnightdust.core.config.MidnightLibConfig;
import eu.midnightdust.lib.config.AutoCommand;
import eu.midnightdust.lib.config.MidnightConfig;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.swing.UIManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MidnightLib {
    public static List<String> hiddenMods = new ArrayList<String>();
    public static final String MOD_ID = "midnightlib";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"midnightlib");

    @Environment(value=EnvType.CLIENT)
    public static void onInitializeClient() {
        try {
            if (!Minecraft.ON_OSX) {
                System.setProperty("java.awt.headless", "false");
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Error | Exception e) {
            LOGGER.error("Error setting system look and feel", e);
        }
        MidnightLibConfig.init(MOD_ID, MidnightLibConfig.class);
    }

    public static void registerAutoCommand() {
        MidnightConfig.configClass.forEach((modid, config) -> {
            for (Field field : config.getFields()) {
                if (!field.isAnnotationPresent(MidnightConfig.Entry.class) || field.isAnnotationPresent(MidnightConfig.Client.class) || field.isAnnotationPresent(MidnightConfig.Hidden.class)) continue;
                new AutoCommand(field, (String)modid);
            }
        });
    }
}

