/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.util;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;
import mc.euphoria_patches.euphoria_patcher.util.EuphoriaLogger;

public class ShaderLoader {
    public static final String IRIS = "iris";
    public static final String OCULUS = "oculus";
    public static final String OPTIFINE = "optifine";
    public static final String UNKNOWN = "unknown";
    private static final Pattern VERSION_PATTERN = Pattern.compile("1\\.(\\d+)\\.(\\d+)");
    private static File cachedShaderFile = null;
    private static boolean shaderFileSearched = false;
    private static String cachedShaderLoader = null;
    private static String cachedMCVersion = null;

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[ShaderLoader] " + message);
    }

    private static File findShaderLoaderFile() {
        if (shaderFileSearched) {
            ShaderLoader.debugLog("Using cached shader file result: " + (cachedShaderFile != null ? cachedShaderFile.getName() : "null"));
            return cachedShaderFile;
        }
        ShaderLoader.debugLog("Searching for shader loader file in mods directory");
        try {
            File modsFolder = new File(String.valueOf(EuphoriaPatcher.modDirectory));
            File[] modFiles = modsFolder.listFiles((dir, name) -> name.toLowerCase().endsWith(".jar"));
            if (modFiles != null) {
                ShaderLoader.debugLog("Found " + modFiles.length + " JAR files in mods directory");
                for (File modFile : modFiles) {
                    String fileName = modFile.getName().toLowerCase();
                    ShaderLoader.debugLog("Checking file: " + fileName);
                    if (!fileName.startsWith(IRIS) && !fileName.startsWith(OCULUS) && !fileName.startsWith(OPTIFINE)) continue;
                    cachedShaderFile = modFile;
                    shaderFileSearched = true;
                    ShaderLoader.debugLog("Found shader loader file: " + modFile.getName());
                    return cachedShaderFile;
                }
            }
            ShaderLoader.debugLog("No shader loader file found");
            shaderFileSearched = true;
            return null;
        }
        catch (Exception e) {
            EuphoriaPatcher.log(2, 0, "Error finding shader loader: " + e.getMessage());
            ShaderLoader.debugLog("Exception while searching for shader loader: " + e.getMessage());
            shaderFileSearched = true;
            return null;
        }
    }

    public static String getShaderLoader() {
        if (cachedShaderLoader != null) {
            ShaderLoader.debugLog("Using cached shader loader type: " + cachedShaderLoader);
            return cachedShaderLoader;
        }
        ShaderLoader.debugLog("Determining shader loader type");
        File shaderFile = ShaderLoader.findShaderLoaderFile();
        if (shaderFile == null) {
            ShaderLoader.debugLog("No shader file found, returning UNKNOWN");
            cachedShaderLoader = UNKNOWN;
            return cachedShaderLoader;
        }
        String fileName = shaderFile.getName().toLowerCase();
        ShaderLoader.debugLog("Analyzing file name: " + fileName);
        if (fileName.startsWith(IRIS)) {
            ShaderLoader.debugLog("Detected IRIS shader loader");
            cachedShaderLoader = IRIS;
        } else if (fileName.startsWith(OCULUS)) {
            ShaderLoader.debugLog("Detected OCULUS shader loader");
            cachedShaderLoader = OCULUS;
        } else if (fileName.startsWith(OPTIFINE)) {
            ShaderLoader.debugLog("Detected OPTIFINE shader loader");
            cachedShaderLoader = OPTIFINE;
        } else {
            ShaderLoader.debugLog("Could not determine shader loader type, returning UNKNOWN");
            cachedShaderLoader = UNKNOWN;
        }
        return cachedShaderLoader;
    }

    public static String getShaderLoaderMCVersion() {
        if (cachedMCVersion != null) {
            ShaderLoader.debugLog("Using cached MC version: " + cachedMCVersion);
            return cachedMCVersion;
        }
        ShaderLoader.debugLog("Extracting Minecraft version from shader loader filename");
        try {
            File shaderFile = ShaderLoader.findShaderLoaderFile();
            if (shaderFile == null) {
                ShaderLoader.debugLog("No shader file found, returning UNKNOWN version");
                cachedMCVersion = UNKNOWN;
                return cachedMCVersion;
            }
            String fileName = shaderFile.getName();
            String lowerFileName = fileName.toLowerCase();
            String extractedVersion = null;
            ShaderLoader.debugLog("Parsing version from filename: " + fileName);
            if (lowerFileName.startsWith("optifine_")) {
                ShaderLoader.debugLog("Detected OptiFine format");
                String[] parts = fileName.split("_");
                if (parts.length >= 2) {
                    extractedVersion = parts[1];
                    ShaderLoader.debugLog("Extracted version: " + extractedVersion);
                }
            } else if (lowerFileName.startsWith(IRIS)) {
                String versionPart;
                int endIndex;
                ShaderLoader.debugLog("Detected Iris format");
                int mcIndex = lowerFileName.indexOf("+mc");
                if (mcIndex != -1 && (endIndex = (versionPart = lowerFileName.substring(mcIndex + 3)).indexOf(".jar")) != -1) {
                    extractedVersion = versionPart.substring(0, endIndex);
                    ShaderLoader.debugLog("Extracted version: " + extractedVersion);
                }
            } else if (lowerFileName.startsWith(OCULUS)) {
                String afterMc;
                int dashIndex;
                ShaderLoader.debugLog("Detected Oculus format");
                int mcIndex = lowerFileName.indexOf("-mc");
                if (mcIndex != -1 && (dashIndex = (afterMc = lowerFileName.substring(mcIndex + 3)).indexOf("-")) != -1) {
                    extractedVersion = afterMc.substring(0, dashIndex);
                    ShaderLoader.debugLog("Extracted version: " + extractedVersion);
                }
            }
            if (extractedVersion != null) {
                Matcher matcher = VERSION_PATTERN.matcher(extractedVersion);
                if (matcher.matches()) {
                    ShaderLoader.debugLog("Valid version format: " + extractedVersion);
                    cachedMCVersion = extractedVersion;
                    return cachedMCVersion;
                }
                ShaderLoader.debugLog("Invalid version format: " + extractedVersion);
                EuphoriaPatcher.log(1, 0, "Invalid version format detected: " + extractedVersion);
            } else {
                ShaderLoader.debugLog("Could not extract version from filename");
            }
            ShaderLoader.debugLog("Setting version to UNKNOWN");
            cachedMCVersion = UNKNOWN;
            return cachedMCVersion;
        }
        catch (Exception e) {
            EuphoriaPatcher.log(2, 0, "Error extracting Minecraft version: " + e.getMessage());
            ShaderLoader.debugLog("Exception extracting Minecraft version: " + e.getMessage());
            cachedMCVersion = UNKNOWN;
            return cachedMCVersion;
        }
    }

    public static boolean isVersionGreaterOrEqual(String version, String minVersion) {
        if (version == null || minVersion == null || UNKNOWN.equals(version) || UNKNOWN.equals(minVersion)) {
            return false;
        }
        try {
            int versionInt = ShaderLoader.convertVersionToInt(version);
            int minVersionInt = ShaderLoader.convertVersionToInt(minVersion);
            return versionInt >= minVersionInt;
        }
        catch (Exception e) {
            EuphoriaPatcher.log(1, 0, "Error comparing versions: " + e.getMessage());
            return false;
        }
    }

    private static int convertVersionToInt(String versionString) {
        Matcher matcher = VERSION_PATTERN.matcher(versionString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid version format: " + versionString);
        }
        int minor = Integer.parseInt(matcher.group(1));
        int release = Integer.parseInt(matcher.group(2));
        return 10000 + minor * 100 + release;
    }

    public static boolean isMinecraftVersionAtLeast(String minVersion) {
        String currentVersion = ShaderLoader.getShaderLoaderMCVersion();
        return ShaderLoader.isVersionGreaterOrEqual(currentVersion, minVersion);
    }
}

