/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.stream.Stream;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;
import mc.euphoria_patches.euphoria_patcher.util.EuphoriaLogger;
import mc.euphoria_patches.shadow.org.apache.commons.compress.archivers.ArchiveEntry;
import mc.euphoria_patches.shadow.org.apache.commons.compress.archivers.ArchiveException;
import mc.euphoria_patches.shadow.org.apache.commons.compress.archivers.ArchiveInputStream;
import mc.euphoria_patches.shadow.org.apache.commons.compress.archivers.ArchiveStreamFactory;
import mc.euphoria_patches.shadow.org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import mc.euphoria_patches.shadow.org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import mc.euphoria_patches.shadow.org.apache.commons.compress.utils.IOUtils;

public class ArchiveUtils {
    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[ArchiveUtils] " + message);
    }

    public static void extract(Path in, Path out) throws IOException, ArchiveException {
        ArchiveUtils.debugLog("Starting extraction from " + in + " to " + out);
        Files.createDirectories(out, new FileAttribute[0]);
        ArchiveUtils.debugLog("Created output directory: " + out);
        try (ArchiveInputStream archiveInputStream = new ArchiveStreamFactory().createArchiveInputStream(new BufferedInputStream(Files.newInputStream(in, new OpenOption[0])));){
            ArchiveEntry entry;
            ArchiveUtils.debugLog("Archive input stream created");
            int extractedCount = 0;
            while ((entry = archiveInputStream.getNextEntry()) != null) {
                if (!archiveInputStream.canReadEntryData(entry)) {
                    ArchiveUtils.debugLog("Skipping unreadable entry: " + entry.getName());
                    continue;
                }
                Path targetFilePath = out.resolve(entry.getName()).normalize();
                ArchiveUtils.debugLog("Processing entry: " + entry.getName() + " -> " + targetFilePath);
                if (entry.isDirectory()) {
                    Files.createDirectories(targetFilePath, new FileAttribute[0]);
                    ArchiveUtils.debugLog("Created directory: " + targetFilePath);
                    continue;
                }
                Files.createDirectories(targetFilePath.getParent(), new FileAttribute[0]);
                OutputStream outputStream = Files.newOutputStream(targetFilePath, new OpenOption[0]);
                try {
                    IOUtils.copy(archiveInputStream, outputStream);
                    ++extractedCount;
                    ArchiveUtils.debugLog("Extracted file: " + targetFilePath);
                }
                finally {
                    if (outputStream == null) continue;
                    outputStream.close();
                }
            }
            ArchiveUtils.debugLog("Extraction completed. " + extractedCount + " files extracted.");
        }
        catch (Exception e) {
            ArchiveUtils.debugLog("Error during extraction: " + e.getMessage());
            throw e;
        }
    }

    public static void archive(Path sourceDir, Path archive) throws IOException {
        ArchiveUtils.debugLog("Starting archive creation from " + sourceDir + " to " + archive);
        try (TarArchiveOutputStream tarOutputStream = new TarArchiveOutputStream(Files.newOutputStream(archive, new OpenOption[0]));){
            ArchiveUtils.debugLog("TAR archive output stream created");
            try (Stream<Path> fileStream = Files.walk(sourceDir, new FileVisitOption[0]);){
                ArchiveUtils.debugLog("Walking file tree in source directory");
                fileStream.sorted(Comparator.comparing(Path::toUri)).forEach(filePath -> ArchiveUtils.addFileToArchive(tarOutputStream, sourceDir, filePath));
            }
            tarOutputStream.finish();
            ArchiveUtils.debugLog("Archive creation completed: " + archive);
        }
        catch (Exception e) {
            ArchiveUtils.debugLog("Error creating archive: " + e.getMessage());
            throw e;
        }
    }

    private static void addFileToArchive(TarArchiveOutputStream tarOutputStream, Path sourceDir, Path filePath) {
        try {
            String fileName = sourceDir.relativize(filePath).toString().replace(File.separatorChar, '/');
            ArchiveUtils.debugLog("Adding to archive: " + fileName);
            TarArchiveEntry tarEntry = new TarArchiveEntry(filePath.toFile(), fileName);
            tarEntry.setModTime(0L);
            tarEntry.setSize(Files.isRegularFile(filePath, new LinkOption[0]) ? Files.size(filePath) : 0L);
            tarEntry.setIds(0, 0);
            tarEntry.setNames("", "");
            tarEntry.setMode(33188);
            tarOutputStream.setLongFileMode(0);
            tarOutputStream.setBigNumberMode(0);
            tarOutputStream.putArchiveEntry(tarEntry);
            if (Files.isRegularFile(filePath, new LinkOption[0])) {
                try (InputStream inputStream = Files.newInputStream(filePath, new OpenOption[0]);){
                    IOUtils.copy(inputStream, (OutputStream)tarOutputStream);
                    ArchiveUtils.debugLog("Added file content: " + fileName);
                }
            }
            tarOutputStream.closeArchiveEntry();
            ArchiveUtils.debugLog("Entry added to archive: " + fileName);
        }
        catch (IOException e) {
            ArchiveUtils.debugLog("Error adding file to archive: " + filePath + " - " + e.getMessage());
            EuphoriaPatcher.log(3, "Could not add files to TAR Archive: " + e.getMessage());
        }
    }
}

