/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;
import mc.euphoria_patches.euphoria_patcher.util.ArchiveUtils;
import mc.euphoria_patches.euphoria_patcher.util.EuphoriaLogger;
import mc.euphoria_patches.euphoria_patcher.util.ShaderpacksWatcher;
import mc.euphoria_patches.euphoria_patcher.util.UpdateChecker;
import mc.euphoria_patches.shadow.org.apache.commons.compress.archivers.ArchiveException;

public class ArchiveOperations {
    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[ArchiveOperations] " + message);
    }

    public static Path extract(Path source, Path targetDir, String operationName) {
        try {
            ArchiveOperations.debugLog("Extracting: " + source.getFileName() + " to " + targetDir);
            if (Files.isDirectory(source, new LinkOption[0])) {
                ArchiveOperations.debugLog("Source is already a directory, no extraction needed");
                return source;
            }
            ArchiveUtils.extract(source, targetDir);
            ArchiveOperations.debugLog("Extraction completed successfully");
            return targetDir;
        }
        catch (IOException | ArchiveException e) {
            ArchiveOperations.debugLog("Error " + operationName + ": " + e.getMessage());
            EuphoriaPatcher.log(2, "Error " + operationName + ": " + e.getMessage());
            return null;
        }
    }

    public static Path archive(Path source, Path targetArchive) {
        try {
            ArchiveOperations.debugLog("Archiving: " + source.getFileName() + " to " + targetArchive);
            ArchiveUtils.archive(source, targetArchive);
            ArchiveOperations.debugLog("Archiving completed successfully");
            return targetArchive;
        }
        catch (IOException e) {
            ArchiveOperations.debugLog("Error creating archive: " + e.getMessage());
            EuphoriaPatcher.log(2, "Error creating archive: " + e.getMessage());
            return null;
        }
    }

    public static boolean verifyBaseArchive(Path baseArchived) {
        try {
            ArchiveOperations.debugLog("Verifying archive: " + baseArchived.getFileName());
            if (EuphoriaPatcher.isDevFunc()) {
                long fileSize = Files.size(baseArchived);
                EuphoriaPatcher.log(0, "Archive Name: " + baseArchived.getFileName() + " Archive size: " + fileSize + " bytes");
            } else {
                boolean isValidSize;
                long fileSize = Files.size(baseArchived);
                ArchiveOperations.debugLog("Archive size: " + fileSize + " bytes, expected: 1340416 bytes");
                boolean bl = isValidSize = fileSize == 1340416L;
                if (!isValidSize) {
                    ArchiveOperations.debugLog("Invalid archive size: verification failed");
                    String fileName = baseArchived.getFileName().toString();
                    if (EuphoriaPatcher.isNewerShaderVersion(fileName)) {
                        String detectedVersion = EuphoriaPatcher.getVersionStringFromFileName(fileName);
                        EuphoriaPatcher.log(3, 8, "Newer shader version in shaderpacks folder detected: " + fileName.replace(".tar", ""));
                        EuphoriaPatcher.log(3, 8, "EuphoriaPatches_1.6.2 only works with ComplementaryShaders_r5.5.1");
                        if (UpdateChecker.isUpdateAvailable() && EuphoriaPatcher.doUpdateChecking) {
                            EuphoriaPatcher.log(3, 8, "Please update EuphoriaPatches to the latest version to support this shader version: " + detectedVersion);
                            EuphoriaPatcher.log(3, 8, "Download it from Modrinth: https://euphoriapatches.com/download");
                        } else {
                            EuphoriaPatcher.log(3, 8, "This version of EuphoriaPatches requires ComplementaryShaders_r5.5.1");
                            EuphoriaPatcher.log(3, 8, "Please download it from https://www.complementary.dev/ or check for an EuphoriaPatches update manually at https://euphoriapatches.com/download");
                        }
                    } else if (fileName.matches("Complementary.*_r5.5.1.*")) {
                        EuphoriaPatcher.log(3, 8, "The shader ComplementaryShaders that was found in your shaderpacks folder can't be used as a base for EuphoriaPatches");
                        EuphoriaPatcher.log(3, 8, "The shader file appears to be incomplete or has been modified.");
                        EuphoriaPatcher.log(3, 8, "Please re-download ComplementaryShaders_r5.5.1 from https://www.complementary.dev/ and place it in the shaderpacks folder.");
                    } else {
                        EuphoriaPatcher.log(3, 8, "The shader ComplementaryShaders that was found in your shaderpacks folder can't be used as a base for EuphoriaPatches");
                        EuphoriaPatcher.log(3, 8, "Please download ComplementaryShaders_r5.5.1 from https://www.complementary.dev/ and place it in the shaderpacks folder.");
                    }
                    EuphoriaPatcher.log(0, "Watching for the correct shader to be added...");
                    EuphoriaPatcher instance = EuphoriaPatcher.getInstance();
                    if (instance != null) {
                        instance.startWatcherAfterByteSizeFailure();
                        ShaderpacksWatcher watcher = instance.getShaderpacksWatcher();
                        if (watcher != null) {
                            watcher.trackInvalidByteSizeFile(fileName);
                        }
                    }
                    return false;
                }
                ArchiveOperations.debugLog("Archive size verification passed");
            }
        }
        catch (IOException e) {
            ArchiveOperations.debugLog("Error during archive size verification: " + e.getMessage());
            EuphoriaPatcher.log(3, "Something went wrong during the file size verification: " + e.getMessage());
            return false;
        }
        return true;
    }

    public static boolean verifyBaseArchiveQuiet(Path baseArchived) {
        try {
            ArchiveOperations.debugLog("Quietly verifying archive: " + baseArchived.getFileName());
            if (EuphoriaPatcher.isDevFunc()) {
                ArchiveOperations.debugLog("Dev mode: bypassing size verification (returning true)");
                return true;
            }
            long fileSize = Files.size(baseArchived);
            boolean isValid = fileSize == 1340416L;
            ArchiveOperations.debugLog("Archive size: " + fileSize + " bytes, expected: 1340416 bytes, valid: " + isValid);
            return isValid;
        }
        catch (IOException e) {
            ArchiveOperations.debugLog("Error during quiet archive verification: " + e.getMessage());
            return false;
        }
    }
}

