/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.features;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;
import mc.euphoria_patches.euphoria_patcher.util.EuphoriaLogger;

public class UpdateShaderLoaderConfig {
    private static volatile boolean pendingReload = false;
    private static volatile Class<?> pendingIrisClass = null;

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[UpdateShaderLoaderConfig] " + message);
    }

    private static Path getShaderLoaderPath() {
        Path shaderLoaderConfig = EuphoriaPatcher.configDirectory.resolve("iris.properties");
        if (!Files.exists(shaderLoaderConfig, new LinkOption[0])) {
            shaderLoaderConfig = EuphoriaPatcher.configDirectory.resolve("oculus.properties");
        }
        if (!Files.exists(shaderLoaderConfig, new LinkOption[0])) {
            shaderLoaderConfig = EuphoriaPatcher.shaderpacks.getParent().resolve("optionsshaders.txt");
        }
        if (!Files.exists(shaderLoaderConfig, new LinkOption[0])) {
            shaderLoaderConfig = null;
        }
        return shaderLoaderConfig;
    }

    public static void checkPendingReload() {
        if (pendingReload && pendingIrisClass != null) {
            try {
                UpdateShaderLoaderConfig.debugLog("Processing pending shader reload on main thread");
                pendingIrisClass.getMethod("reload", new Class[0]).invoke(null, new Object[0]);
                UpdateShaderLoaderConfig.debugLog("Successfully reloaded shaders");
            }
            catch (Exception e) {
                EuphoriaPatcher.log(2, 0, "Error reloading Iris shaders:" + e.getMessage());
            }
            finally {
                pendingReload = false;
                pendingIrisClass = null;
            }
        }
    }

    public static void updateShaderLoaderConfig(boolean styleUnbound, boolean styleReimagined) {
        block23: {
            UpdateShaderLoaderConfig.debugLog("Starting updateShaderLoaderConfig - Unbound: " + styleUnbound + ", Reimagined: " + styleReimagined);
            Path shaderLoaderConfig = UpdateShaderLoaderConfig.getShaderLoaderPath();
            if (shaderLoaderConfig == null) {
                UpdateShaderLoaderConfig.debugLog("No shader loader config found");
                EuphoriaPatcher.log(0, "No shader loader config found");
                return;
            }
            UpdateShaderLoaderConfig.debugLog("Found shader loader config at: " + shaderLoaderConfig);
            String shaderLoaderName = shaderLoaderConfig.toString().contains("iris") ? "iris.properties" : (shaderLoaderConfig.toString().contains("oculus") ? "oculus.properties" : "OptiFine's optionsshaders.txt");
            UpdateShaderLoaderConfig.debugLog("Identified shader loader: " + shaderLoaderName);
            File fileToBeModified = shaderLoaderConfig.toFile();
            StringBuilder oldContent = new StringBuilder();
            try {
                BufferedReader reader = new BufferedReader(new FileReader(fileToBeModified));
                try {
                    String line;
                    UpdateShaderLoaderConfig.debugLog("Reading shader loader config file");
                    while ((line = reader.readLine()) != null) {
                        oldContent.append(line).append(System.lineSeparator());
                    }
                    UpdateShaderLoaderConfig.debugLog("Successfully read shader loader config file");
                    boolean hasPatchName = oldContent.toString().contains("EuphoriaPatches");
                    boolean hasPatchVersion = oldContent.toString().contains("_1.6.2");
                    UpdateShaderLoaderConfig.debugLog("Config contains patch name: " + hasPatchName + ", contains patch version: " + hasPatchVersion);
                    if (hasPatchName && !hasPatchVersion) {
                        UpdateShaderLoaderConfig.debugLog("Need to update shader config - found old version reference");
                        String newContent = UpdateShaderLoaderConfig.setNewShaderLoaderSelectedPackName(oldContent, styleUnbound, styleReimagined);
                        UpdateShaderLoaderConfig.debugLog("Generated new content for config file");
                        try (FileWriter writer = new FileWriter(fileToBeModified);){
                            UpdateShaderLoaderConfig.debugLog("Writing updated content to config file");
                            writer.write(newContent);
                            UpdateShaderLoaderConfig.debugLog("Successfully wrote updated content");
                        }
                        catch (IOException e) {
                            UpdateShaderLoaderConfig.debugLog("Error writing to config file: " + e.getMessage());
                            EuphoriaPatcher.log(3, 0, "Error writing to " + shaderLoaderName + " config file: " + e.getMessage());
                            reader.close();
                            return;
                        }
                        String oldPack = oldContent.toString().contains("shaderPack=") ? oldContent.toString().split("shaderPack=")[1].split("\n")[0].trim() : "unknown";
                        String newPack = newContent.contains("shaderPack=") ? newContent.split("shaderPack=")[1].split("\n")[0].trim() : "unknown";
                        UpdateShaderLoaderConfig.debugLog("Updated shader pack reference from '" + oldPack + "' to '" + newPack + "'");
                        EuphoriaPatcher.log(0, "Successfully applied new version in " + shaderLoaderName + " config file!");
                        EuphoriaPatcher.log(0, oldPack + " -> " + newPack);
                        break block23;
                    }
                    UpdateShaderLoaderConfig.debugLog("No update needed for shader config");
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Throwable hasPatchName) {
                        Throwable line;
                        line.addSuppressed(hasPatchName);
                    }
                }
            }
            catch (IOException e) {
                UpdateShaderLoaderConfig.debugLog("Error accessing shader loader config file: " + e.getMessage());
                EuphoriaPatcher.log(3, 0, "Error reading or writing to " + shaderLoaderName + " config file: " + e.getMessage());
                return;
            }
        }
        Class<?> irisClass = null;
        UpdateShaderLoaderConfig.debugLog("Attempting to find Iris class for shader reload");
        try {
            irisClass = Class.forName("net.irisshaders.iris.Iris");
            UpdateShaderLoaderConfig.debugLog("Found Iris class at net.irisshaders.iris.Iris");
        }
        catch (ClassNotFoundException e1) {
            UpdateShaderLoaderConfig.debugLog("Iris class not found at net.irisshaders.iris.Iris, trying alternative location");
            try {
                irisClass = Class.forName("net.coderbot.iris.Iris");
                UpdateShaderLoaderConfig.debugLog("Found Iris class at net.coderbot.iris.Iris");
            }
            catch (ClassNotFoundException e2) {
                UpdateShaderLoaderConfig.debugLog("Iris not found - this is normal if Iris isn't installed");
                return;
            }
        }
        UpdateShaderLoaderConfig.debugLog("Scheduling shader reload on next game tick");
        pendingIrisClass = irisClass;
        pendingReload = true;
    }

    private static String setNewShaderLoaderSelectedPackName(StringBuilder oldContent, boolean styleUnbound, boolean styleReimagined) {
        String style;
        String string = style = styleUnbound ? "Unbound" : "Reimagined";
        if (styleUnbound && styleReimagined) {
            style = oldContent.toString().contains("EuphoriaPatches") && !oldContent.toString().contains("_1.6.2") && oldContent.toString().contains("Unbound") ? "Unbound" : "Reimagined";
        }
        String newName = "Complementary" + style + "_r5.5.1 + EuphoriaPatches_1.6.2";
        return oldContent.toString().replaceAll("shaderPack=.*", "shaderPack=" + newName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Path getCurrentShaderpackPath() {
        Path shaderLoaderConfig = UpdateShaderLoaderConfig.getShaderLoaderPath();
        if (shaderLoaderConfig == null) {
            return null;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(shaderLoaderConfig.toFile()));){
            String line;
            do {
                if ((line = reader.readLine()) == null) return null;
            } while (!line.startsWith("shaderPack="));
            String shaderpackName = line.substring("shaderPack=".length()).trim();
            if (shaderpackName.isEmpty() || shaderpackName.equalsIgnoreCase("OFF")) {
                Path path = null;
                return path;
            }
            Path shaderpackPath = shaderpackName.endsWith(".zip") ? EuphoriaPatcher.shaderpacks.resolve(shaderpackName) : EuphoriaPatcher.shaderpacks.resolve(shaderpackName);
            if (Files.exists(shaderpackPath, new LinkOption[0])) {
                Path path = shaderpackPath;
                return path;
            }
            EuphoriaPatcher.log(2, 0, "Shaderpack specified in config doesn't exist: " + shaderpackPath);
            Path path = null;
            return path;
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, 0, "Error reading shader loader config: " + e.getMessage());
        }
        return null;
    }
}

