/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing;

import com.mojang.brigadier.CommandDispatcher;
import com.simibubi.create.content.logistics.depot.DepotBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.tterrag.registrate.util.RegistrateDistExecutor;
import fr.iglee42.createcasing.CreateCasingClient;
import fr.iglee42.createcasing.commands.CreateCasingCommand;
import fr.iglee42.createcasing.config.ModConfigs;
import fr.iglee42.createcasing.registries.ModBlockEntities;
import fr.iglee42.createcasing.registries.ModBlocks;
import fr.iglee42.createcasing.registries.ModCreativeModeTabs;
import fr.iglee42.createcasing.registries.ModItems;
import fr.iglee42.createcasing.registries.ModPackets;
import fr.iglee42.createcasing.registries.ModSounds;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="createcasing")
public class CreateCasing {
    public static final String MODID = "createcasing";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"createcasing");
    public static final CreateRegistrate REGISTRATE = (CreateRegistrate)CreateRegistrate.create((String)"createcasing").defaultCreativeTab((ResourceKey)null);
    public static List<ItemLike> hidedItems = new ArrayList<ItemLike>();

    public CreateCasing(IEventBus modEventBus, ModContainer container) {
        IEventBus neoForgeEventBus = NeoForge.EVENT_BUS;
        REGISTRATE.registerEventListeners(modEventBus);
        ModSounds.prepare();
        ModBlocks.register();
        ModItems.register();
        ModBlockEntities.register();
        ModCreativeModeTabs.register(modEventBus);
        ModPackets.register();
        ModBlocks.registerEncasedShafts();
        ModConfigs.register(ModLoadingContext.get(), container);
        RegistrateDistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CreateCasingClient.onCtorClient(modEventBus));
        neoForgeEventBus.addListener(this::registerCommands);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(ModSounds::register);
        modEventBus.addListener(this::registerCapabilities);
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static void hideItem(ItemLike it) {
        hidedItems.add(it);
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void registerCommands(RegisterCommandsEvent event) {
        if (!FMLEnvironment.production) {
            new CreateCasingCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.DEPOT.get(), (be, context) -> ((DepotBehaviour)be.getBehaviour((BehaviourType)DepotBehaviour.TYPE)).itemHandler);
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.API_DEPOT.get(), (be, context) -> ((DepotBehaviour)be.getBehaviour((BehaviourType)DepotBehaviour.TYPE)).itemHandler);
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
    }
}

