/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class TreePollinationRecipe
implements Recipe<RecipeInput> {
    public final Ingredient leafA;
    public final Ingredient leafB;
    public final ItemStack result;
    public final float chance;

    public TreePollinationRecipe(Ingredient leafA, Ingredient leafB, ItemStack result, float chance) {
        this.leafA = leafA;
        this.leafB = leafB;
        this.result = result;
        this.chance = chance;
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean matches(RecipeInput container, Level level) {
        return false;
    }

    public boolean matches(BlockState leafAState, BlockState leafBState) {
        return this.leafA.test(new ItemStack((ItemLike)leafAState.getBlock().asItem())) && this.leafB.test(new ItemStack((ItemLike)leafBState.getBlock().asItem()));
    }

    public ItemStack assemble(RecipeInput container, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)TreeRegistrator.TREE_POLLINATION.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)TreeRegistrator.TREE_POLLINATION_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<TreePollinationRecipe> {
        private static final MapCodec<TreePollinationRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("leafA").forGetter(recipe -> recipe.leafA), (App)Ingredient.CODEC.fieldOf("leafB").forGetter(recipe -> recipe.leafB), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.FLOAT.fieldOf("chance").orElse((Object)Float.valueOf(0.1f)).forGetter(recipe -> Float.valueOf(recipe.chance))).apply((Applicative)builder, TreePollinationRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, TreePollinationRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<TreePollinationRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, TreePollinationRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static TreePollinationRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            return new TreePollinationRecipe((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer), buffer.readFloat());
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, TreePollinationRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.leafA);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.leafB);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeFloat(recipe.chance);
        }
    }
}

