/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.integrations.productivebees;

import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.ExpansionBox;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.event.BeeReleaseEvent;
import cy.jdkdigital.productivelib.event.CollectValidUpgradesEvent;
import cy.jdkdigital.productivetrees.Config;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.registry.WoodObject;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToIntFunction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredHolder;

public class CompatHandler {
    private static List<DeferredHolder<Block, Block>> HIVES = new ArrayList<DeferredHolder<Block, Block>>();
    private static List<DeferredHolder<Block, Block>> BOXES = new ArrayList<DeferredHolder<Block, Block>>();

    public static void createHive(String name, WoodObject woodObject, ToIntFunction<BlockState> lightLevel) {
        ModBlocks.HIVES.put("advanced_" + name + "_beehive", TreeRegistrator.registerBlock("advanced_" + name + "_beehive", () -> new AdvancedBeehive(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEEHIVE).lightLevel(lightLevel)), true));
        ModBlocks.EXPANSIONS.put("expansion_box_" + name, TreeRegistrator.registerBlock("expansion_box_" + name, () -> new ExpansionBox(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEEHIVE).lightLevel(lightLevel)), true));
    }

    public static void collectValidUpgrades(CollectValidUpgradesEvent event) {
        if (event.getBlockEntity() instanceof AdvancedBeehiveBlockEntity) {
            event.addValidUpgrade((Item)TreeRegistrator.UPGRADE_POLLEN_SIEVE.get());
        }
    }

    public static void beeRelease(BeeReleaseEvent event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (event.getBeeState().equals((Object)BeehiveBlockEntity.BeeReleaseStatus.HONEY_DELIVERED) && (level = event.getBlockEntity()) instanceof BeehiveBlockEntity) {
                BeehiveBlockEntity beehiveBlockEntity = (BeehiveBlockEntity)level;
                if (event.getBee().getHivePos() != null) {
                    AdvancedBeehiveBlockEntity advancedBeehiveBlockEntity;
                    int sieveUpgrades;
                    ProductiveBee pBee;
                    int n;
                    if (beehiveBlockEntity instanceof AdvancedBeehiveBlockEntity) {
                        AdvancedBeehiveBlockEntity advancedBeehiveBlockEntity2 = (AdvancedBeehiveBlockEntity)beehiveBlockEntity;
                        n = 2 * advancedBeehiveBlockEntity2.getUpgradeCount((Item)ModItems.UPGRADE_RANGE.get());
                    } else {
                        n = 0;
                    }
                    int distance = 4 + n;
                    Bee bee = event.getBee();
                    boolean isSpecialPollinator = bee instanceof ProductiveBee && (pBee = (ProductiveBee)bee).getBeeName().equals("allergy");
                    ArrayList<BlockState> uniqueLeaves = new ArrayList<BlockState>();
                    TreeUtil.pollinateLeaves((Level)level2, event.getBee().getHivePos(), distance, isSpecialPollinator, uniqueLeaves);
                    if (!uniqueLeaves.isEmpty() && beehiveBlockEntity instanceof AdvancedBeehiveBlockEntity && (sieveUpgrades = (advancedBeehiveBlockEntity = (AdvancedBeehiveBlockEntity)beehiveBlockEntity).getUpgradeCount((Item)TreeRegistrator.UPGRADE_POLLEN_SIEVE.get())) > 0 && level2.random.nextInt(100) < (Integer)Config.SERVER.pollenChanceFromSieve.get() * (isSpecialPollinator ? 5 : 1)) {
                        BlockState pollenLeaf = (BlockState)uniqueLeaves.get(level2.random.nextInt(uniqueLeaves.size()));
                        ItemStack pollenStack = TreeUtil.getPollen(pollenLeaf.getBlock());
                        ((InventoryHandlerHelper.BlockEntityItemStackHandler)advancedBeehiveBlockEntity.inventoryHandler).addOutput(pollenStack);
                    }
                }
            }
        }
    }
}

