/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.datagen;

import cy.jdkdigital.productivetrees.ProductiveTrees;
import cy.jdkdigital.productivetrees.datagen.ItemTagProvider;
import cy.jdkdigital.productivetrees.datagen.recipe.SawmillRecipeBuilder;
import cy.jdkdigital.productivetrees.datagen.recipe.TreePollinationRecipeBuilder;
import cy.jdkdigital.productivetrees.registry.ModTags;
import cy.jdkdigital.productivetrees.registry.TreeFinder;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.registry.WoodObject;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;

public class RecipeProvider
extends net.minecraft.data.recipes.RecipeProvider
implements IConditionBuilder {
    public RecipeProvider(PackOutput gen, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(gen, pRegistries);
    }

    public String getName() {
        return "Productive Tress Recipes";
    }

    protected void buildRecipes(RecipeOutput pRecipeOutput) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.PAPER, (int)2).unlockedBy("has_sawdust", RecipeProvider.has(ModTags.SAWDUST)).pattern("###").pattern("#W#").pattern("###").define(Character.valueOf('#'), Ingredient.of(ModTags.SAWDUST)).define(Character.valueOf('W'), DataComponentIngredient.of((boolean)false, (ItemStack)PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"sawdust_to_paper_water_bottle"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.PAPER, (int)2).unlockedBy("has_sawdust", RecipeProvider.has(ModTags.SAWDUST)).pattern("###").pattern("#W#").pattern("###").define(Character.valueOf('#'), Ingredient.of(ModTags.SAWDUST)).define(Character.valueOf('W'), (ItemLike)Items.WATER_BUCKET).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"sawdust_to_paper"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BLUE_DYE, (int)2).unlockedBy(RecipeProvider.getHasName((ItemLike)((ItemLike)TreeRegistrator.HAEMATOXYLIN.get())), RecipeProvider.has((ItemLike)((ItemLike)TreeRegistrator.HAEMATOXYLIN.get()))).pattern("##").define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TreeRegistrator.HAEMATOXYLIN.get()})).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"blue_dye_from_haematoxylin"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.PURPLE_DYE, (int)2).unlockedBy(RecipeProvider.getHasName((ItemLike)((ItemLike)TreeRegistrator.HAEMATOXYLIN.get())), RecipeProvider.has((ItemLike)((ItemLike)TreeRegistrator.HAEMATOXYLIN.get()))).pattern("#").pattern("#").define(Character.valueOf('#'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TreeRegistrator.HAEMATOXYLIN.get()})).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"purple_dye_from_haematoxylin"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.SUGAR, (int)3).unlockedBy("has_maple_syrup", RecipeProvider.has(ModTags.MAPLE_SYRUP)).requires(ModTags.MAPLE_SYRUP).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"sugar_from_maple_syrup"));
        TreeFinder.trees.forEach((id, treeObject) -> {
            Block planks = TreeUtil.getBlock(treeObject.getId(), "_planks");
            RecipeProvider.planksFromLogs(pRecipeOutput, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_planks"), (TagKey<Item>)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)(id.getPath() + "_logs"))));
            RecipeProvider.woodFromLogs(pRecipeOutput, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_wood"), (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_log"));
            if (!ProductiveTrees.isMinimal) {
                RecipeProvider.shapedVariant(pRecipeOutput, BlockFamily.Variant.STAIRS, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_stairs"), (ItemLike)planks);
                RecipeProvider.shapedVariant(pRecipeOutput, BlockFamily.Variant.SLAB, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_slab"), (ItemLike)planks);
                RecipeProvider.shapedVariant(pRecipeOutput, BlockFamily.Variant.PRESSURE_PLATE, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_pressure_plate"), (ItemLike)planks);
                RecipeProvider.shapedVariant(pRecipeOutput, BlockFamily.Variant.BUTTON, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_button"), (ItemLike)planks);
                RecipeProvider.shapedVariant(pRecipeOutput, BlockFamily.Variant.FENCE, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_fence"), (ItemLike)planks);
                RecipeProvider.shapedVariant(pRecipeOutput, BlockFamily.Variant.FENCE_GATE, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_fence_gate"), (ItemLike)planks);
                RecipeProvider.shapedVariant(pRecipeOutput, BlockFamily.Variant.DOOR, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_door"), (ItemLike)planks);
                RecipeProvider.shapedVariant(pRecipeOutput, BlockFamily.Variant.TRAPDOOR, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_trapdoor"), (ItemLike)planks);
                RecipeProvider.shapedVariant(pRecipeOutput, BlockFamily.Variant.SIGN, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_sign"), (ItemLike)planks);
                RecipeProvider.hangingSign(pRecipeOutput, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_hanging_sign"), (ItemLike)planks);
                ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)TreeUtil.getBlock(treeObject.getId(), "_bookshelf")).define(Character.valueOf('#'), (ItemLike)planks).define(Character.valueOf('X'), (ItemLike)Items.BOOK).pattern("###").pattern("XXX").pattern("###").unlockedBy("has_book", RecipeProvider.has((ItemLike)planks)).save(pRecipeOutput, treeObject.getId().withPath(p -> "bookshelves/" + p + "_bookshelf"));
            }
            this.buildSawmillRecipe((WoodObject)treeObject, pRecipeOutput);
        });
        this.buildCrateRecipes(pRecipeOutput);
        this.buildTreeBreedingRecipes(pRecipeOutput);
        this.buildVanillaSawmillRecipes(pRecipeOutput);
        this.buildCompatSawmillRecipes(pRecipeOutput);
        TreeRegistrator.ROASTED_NUTS.forEach(cropConfig -> {
            Item roastedNut = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)cropConfig.name()));
            Item rawNut = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)cropConfig.name().replace("roasted_", "")));
            SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{rawNut}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)roastedNut, (float)0.1f, (int)120).unlockedBy(RecipeProvider.getHasName((ItemLike)rawNut), RecipeProvider.has((ItemLike)rawNut)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("roasting/" + cropConfig.name() + "_smelting")));
            SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{rawNut}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)roastedNut, (float)0.1f, (int)20).unlockedBy(RecipeProvider.getHasName((ItemLike)rawNut), RecipeProvider.has((ItemLike)rawNut)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("roasting/" + cropConfig.name() + "_smoking")));
            Item roastedNutCrate = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)(cropConfig.name() + "_crate")));
            Item rawNutCrate = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)(cropConfig.name().replace("roasted_", "") + "_crate")));
            if (rawNutCrate != null) {
                SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{rawNutCrate}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)roastedNutCrate, (float)0.9f, (int)1080).unlockedBy(RecipeProvider.getHasName((ItemLike)rawNutCrate), RecipeProvider.has((ItemLike)rawNutCrate)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("roasting/" + cropConfig.name() + "_crate_smelting")));
                SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{rawNutCrate}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)roastedNutCrate, (float)0.9f, (int)180).unlockedBy(RecipeProvider.getHasName((ItemLike)rawNutCrate), RecipeProvider.has((ItemLike)rawNutCrate)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("roasting/" + cropConfig.name() + "_crate_smoking")));
            }
        });
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)TreeRegistrator.RUBBER.get()}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)TreeRegistrator.CURED_RUBBER.get()), (float)0.1f, (int)120).unlockedBy(RecipeProvider.getHasName((ItemLike)((ItemLike)TreeRegistrator.RUBBER.get())), RecipeProvider.has((ItemLike)((ItemLike)TreeRegistrator.RUBBER.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"cured_rubber"));
    }

    private static void planksFromLogs(RecipeOutput consumer, ItemLike result, TagKey<Item> pLogs) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result, (int)4).requires(Ingredient.of(pLogs)).group("planks").unlockedBy("has_logs", RecipeProvider.has(pLogs)).save(consumer, RecipeProvider.prefixedRecipeId(result, "planks/"));
    }

    protected static void woodFromLogs(RecipeOutput consumer, ItemLike pWood, ItemLike pLog) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)pWood, (int)3).define(Character.valueOf('#'), pLog).pattern("##").pattern("##").group("bark").unlockedBy("has_log", RecipeProvider.has((ItemLike)pLog)).save(consumer, RecipeProvider.prefixedRecipeId(pWood, "wood/"));
    }

    private static void shapedVariant(RecipeOutput consumer, BlockFamily.Variant variant, ItemLike result, ItemLike plank) {
        RecipeBuilder builder = (RecipeBuilder)((BiFunction)SHAPE_BUILDERS.get(variant)).apply(result, plank);
        builder.group(variant.name().toLowerCase());
        builder.unlockedBy(RecipeProvider.getHasName((ItemLike)plank), RecipeProvider.has((ItemLike)plank));
        builder.save(consumer, RecipeProvider.prefixedRecipeId(result, variant.name().toLowerCase() + "/"));
    }

    protected static void hangingSign(RecipeOutput consumer, ItemLike result, ItemLike plank) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)result, (int)6).group("hanging_sign").define(Character.valueOf('#'), plank).define(Character.valueOf('X'), (ItemLike)Items.CHAIN).pattern("X X").pattern("###").pattern("###").unlockedBy("has_stripped_logs", RecipeProvider.has((ItemLike)plank)).save(consumer, RecipeProvider.prefixedRecipeId(result, "hanging_sign/"));
    }

    private static ResourceLocation prefixedRecipeId(ItemLike item, String prefix) {
        return BuiltInRegistries.ITEM.getKey((Object)item.asItem()).withPath(path -> prefix + path);
    }

    private void buildSawmillRecipe(WoodObject treeObject, RecipeOutput consumer) {
        String name = treeObject.getId().getPath();
        SawmillRecipeBuilder.tree(treeObject, (TagKey<Item>)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)(treeObject.getId().getPath() + "_logs"))), TreeUtil.getBlock(treeObject.getId(), "_planks")).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("sawmill/" + name + "_planks_from_log")));
    }

    private void buildVanillaSawmillRecipes(RecipeOutput consumer) {
        SawmillRecipeBuilder.direct(Ingredient.of((TagKey)ItemTags.OAK_LOGS), new ItemStack((ItemLike)Items.OAK_PLANKS, 6), new ItemStack((ItemLike)TreeRegistrator.SAWDUST.get(), 2), ItemStack.EMPTY).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"sawmill/oak_planks_from_log"));
        SawmillRecipeBuilder.direct(Ingredient.of((TagKey)ItemTags.SPRUCE_LOGS), new ItemStack((ItemLike)Items.SPRUCE_PLANKS, 6), new ItemStack((ItemLike)TreeRegistrator.SAWDUST.get(), 2), ItemStack.EMPTY).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"sawmill/spruce_planks_from_log"));
        SawmillRecipeBuilder.direct(Ingredient.of((TagKey)ItemTags.ACACIA_LOGS), new ItemStack((ItemLike)Items.ACACIA_PLANKS, 6), new ItemStack((ItemLike)TreeRegistrator.SAWDUST.get(), 2), ItemStack.EMPTY).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"sawmill/acacia_planks_from_log"));
        SawmillRecipeBuilder.direct(Ingredient.of((TagKey)ItemTags.BIRCH_LOGS), new ItemStack((ItemLike)Items.BIRCH_PLANKS, 6), new ItemStack((ItemLike)TreeRegistrator.SAWDUST.get(), 2), ItemStack.EMPTY).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"sawmill/birch_planks_from_log"));
        SawmillRecipeBuilder.direct(Ingredient.of((TagKey)ItemTags.JUNGLE_LOGS), new ItemStack((ItemLike)Items.JUNGLE_PLANKS, 6), new ItemStack((ItemLike)TreeRegistrator.SAWDUST.get(), 2), ItemStack.EMPTY).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"sawmill/jungle_planks_from_log"));
        SawmillRecipeBuilder.direct(Ingredient.of((TagKey)ItemTags.CHERRY_LOGS), new ItemStack((ItemLike)Items.CHERRY_PLANKS, 6), new ItemStack((ItemLike)TreeRegistrator.SAWDUST.get(), 2), ItemStack.EMPTY).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"sawmill/cherry_planks_from_log"));
        SawmillRecipeBuilder.direct(Ingredient.of((TagKey)ItemTags.MANGROVE_LOGS), new ItemStack((ItemLike)Items.MANGROVE_PLANKS, 6), new ItemStack((ItemLike)TreeRegistrator.SAWDUST.get(), 2), ItemStack.EMPTY).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"sawmill/mangrove_planks_from_log"));
        SawmillRecipeBuilder.direct(Ingredient.of((TagKey)ItemTags.DARK_OAK_LOGS), new ItemStack((ItemLike)Items.DARK_OAK_PLANKS, 6), new ItemStack((ItemLike)TreeRegistrator.SAWDUST.get(), 2), ItemStack.EMPTY).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"sawmill/dark_oak_planks_from_log"));
        SawmillRecipeBuilder.direct(Ingredient.of((TagKey)ItemTags.CRIMSON_STEMS), new ItemStack((ItemLike)Items.CRIMSON_PLANKS, 6), new ItemStack((ItemLike)TreeRegistrator.SAWDUST.get(), 2), ItemStack.EMPTY).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"sawmill/crimson_planks_from_log"));
        SawmillRecipeBuilder.direct(Ingredient.of((TagKey)ItemTags.WARPED_STEMS), new ItemStack((ItemLike)Items.WARPED_PLANKS, 6), new ItemStack((ItemLike)TreeRegistrator.SAWDUST.get(), 2), ItemStack.EMPTY).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)"sawmill/warped_planks_from_log"));
    }

    private void buildCompatSawmillRecipes(RecipeOutput consumer) {
    }

    private void buildCrateRecipes(RecipeOutput consumer) {
        TreeRegistrator.CRATED_CROPS.forEach(crate -> {
            String cropName = crate.getPath().replace("_crate", "");
            Item crateItem = (Item)BuiltInRegistries.ITEM.get(crate);
            Item cropItem = (Item)BuiltInRegistries.ITEM.get(crate.withPath(p -> cropName));
            TagKey cropTag = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)ItemTagProvider.tagName(cropName)));
            if (TreeRegistrator.FRUITS.stream().filter(cropConfig -> cropConfig.name().equals(cropName)).toList().size() > 0) {
                cropTag = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("fruits/" + ItemTagProvider.tagName(cropName))));
            } else if (TreeRegistrator.BERRIES.stream().filter(cropConfig -> cropConfig.name().equals(cropName)).toList().size() > 0) {
                cropTag = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("berries/" + ItemTagProvider.tagName(cropName))));
            } else if (TreeRegistrator.NUTS.stream().filter(cropConfig -> cropConfig.name().equals(cropName)).toList().size() > 0 || TreeRegistrator.ROASTED_NUTS.stream().filter(cropConfig -> cropConfig.name().equals(cropName)).toList().size() > 0) {
                cropTag = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("nuts/" + ItemTagProvider.tagName(cropName))));
            }
            if (cropName.equals("red_delicious_apple")) {
                cropItem = Items.APPLE;
                cropTag = null;
            }
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)cropItem, (int)9).unlockedBy(RecipeProvider.getHasName((ItemLike)cropItem), RecipeProvider.has((ItemLike)cropItem)).requires((ItemLike)crateItem).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("crates/" + crate.getPath() + "_unpack")));
            ShapedRecipeBuilder rBuilder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)crateItem).unlockedBy(RecipeProvider.getHasName((ItemLike)cropItem), RecipeProvider.has((ItemLike)cropItem)).pattern("###").pattern("#R#").pattern("###").define(Character.valueOf('R'), (ItemLike)cropItem);
            if (cropTag != null) {
                rBuilder.define(Character.valueOf('#'), cropTag);
            } else {
                rBuilder.define(Character.valueOf('#'), (ItemLike)cropItem);
            }
            rBuilder.save(consumer, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("crates/" + crate.getPath())));
        });
    }

    private void buildTreeBreedingRecipes(RecipeOutput consumer) {
        RecipeProvider.treeBreeding(consumer, "silver_lime", Blocks.OAK_LEAVES, Blocks.BIRCH_LEAVES, 0.55f);
        RecipeProvider.treeBreeding(consumer, "cacao", Blocks.JUNGLE_LEAVES, Blocks.CHERRY_LEAVES, 0.35f);
        RecipeProvider.treeBreeding(consumer, "walnut", "silver_lime", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.CHERRY_LEAVES}), 0.1f);
        RecipeProvider.treeBreeding(consumer, "sweet_chestnut", "walnut", RecipeProvider.getLeafIngredient("wild_cherry", "silver_lime"), 0.1f);
        RecipeProvider.treeBreeding(consumer, "european_larch", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.SPRUCE_LEAVES}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.BIRCH_LEAVES}), 0.1f);
        RecipeProvider.treeBreeding(consumer, "sugar_maple", "european_larch", "red_maple", 0.05f);
        RecipeProvider.treeBreeding(consumer, "citron", "silver_lime", "sour_cherry", 0.05f);
        RecipeProvider.treeBreeding(consumer, "plum", "citron", "wild_cherry", 0.05f);
        RecipeProvider.treeBreeding(consumer, "bull_pine", "european_larch", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.SPRUCE_LEAVES}), 0.1f);
        RecipeProvider.treeBreeding(consumer, "sequoia", "european_larch", "bull_pine", 0.05f);
        RecipeProvider.treeBreeding(consumer, "teak", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.DARK_OAK_LEAVES}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.JUNGLE_LEAVES}), 0.4f);
        RecipeProvider.treeBreeding(consumer, "ipe", "teak", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.DARK_OAK_LEAVES}), 0.1f);
        RecipeProvider.treeBreeding(consumer, "aquilaria", "teak", "ipe", 0.1f);
        RecipeProvider.treeBreeding(consumer, "kapok", "teak", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.JUNGLE_LEAVES}), 0.1f);
        RecipeProvider.treeBreeding(consumer, "ceylon_ebony", "kapok", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.DARK_OAK_LEAVES}), 0.1f);
        RecipeProvider.treeBreeding(consumer, "purple_crepe_myrtle", "ceylon_ebony", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.CHERRY_LEAVES}), 0.05f);
        RecipeProvider.treeBreeding(consumer, "zebrano", "white_poplar", "ceylon_ebony", 0.05f);
        RecipeProvider.treeBreeding(consumer, "yellow_meranti", "ceylon_ebony", "kapok", 0.1f);
        RecipeProvider.treeBreeding(consumer, "mahogany", "yellow_meranti", "kapok", 0.1f);
        RecipeProvider.treeBreeding(consumer, "padauk", "red_maple", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.JUNGLE_LEAVES}), 0.05f);
        RecipeProvider.treeBreeding(consumer, "dogwood", "silver_lime", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.CHERRY_LEAVES}), 0.05f);
        RecipeProvider.treeBreeding(consumer, "balsa", "teak", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.ACACIA_LEAVES}), 0.1f);
        RecipeProvider.treeBreeding(consumer, "cocobolo", "balsa", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.DARK_OAK_LEAVES}), 0.1f);
        RecipeProvider.treeBreeding(consumer, "wenge", "balsa", "cocobolo", 0.1f);
        RecipeProvider.treeBreeding(consumer, "socotra_dragon", "wenge", "cocobolo", 0.1f);
        RecipeProvider.treeBreeding(consumer, "grandidiers_baobab", "balsa", "wenge", 0.1f);
        RecipeProvider.treeBreeding(consumer, "blue_mahoe", "teak", "balsa", 0.05f);
        RecipeProvider.treeBreeding(consumer, "white_willow", "silver_lime", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.OAK_LEAVES, Blocks.BIRCH_LEAVES}), 0.05f);
        RecipeProvider.treeBreeding(consumer, "greenheart", "mahogany", "kapok", 0.1f);
        RecipeProvider.treeBreeding(consumer, "papaya", "wild_cherry", "cacao", 0.05f);
        RecipeProvider.treeBreeding(consumer, "date_palm", "papaya", "cacao", 0.05f);
        RecipeProvider.treeBreeding(consumer, "asai_palm", "date_palm", "black_cherry", 0.05f);
        RecipeProvider.treeBreeding(consumer, "persimmon", "ceylon_ebony", Ingredient.of((ItemLike[])new ItemLike[]{RecipeProvider.getLeafIngredient("purple_crepe_myrtle", "moonlight_magic_crepe_myrtle", "red_crepe_myrtle", "tuscarora_crepe_myrtle").getItems()[0].getItem()}), 0.05f);
        RecipeProvider.treeBreeding(consumer, "myrtle_ebony", "ceylon_ebony", "persimmon", 0.05f);
        RecipeProvider.treeBreeding(consumer, "pomegranate", "holly", Ingredient.of((ItemLike[])new ItemLike[]{RecipeProvider.getLeafIngredient("purple_crepe_myrtle", "moonlight_magic_crepe_myrtle", "red_crepe_myrtle", "tuscarora_crepe_myrtle").getItems()[0].getItem()}), 0.05f);
        RecipeProvider.treeBreeding(consumer, "white_poplar", "white_willow", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.OAK_LEAVES, Blocks.BIRCH_LEAVES, RecipeProvider.getLeafIngredient("silver_lime").getItems()[0].getItem()}), 0.05f);
        RecipeProvider.treeBreeding(consumer, "red_delicious_apple", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.CHERRY_LEAVES}), Ingredient.of((ItemLike[])new ItemLike[]{Blocks.OAK_LEAVES, Blocks.DARK_OAK_LEAVES}), 0.1f);
        RecipeProvider.treeBreeding(consumer, "granny_smith_apple", "red_delicious_apple", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.CHERRY_LEAVES}), 0.1f);
        RecipeProvider.treeBreeding(consumer, "golden_delicious_apple", "red_delicious_apple", "granny_smith_apple", 0.1f);
        RecipeProvider.treeBreeding(consumer, "beliy_naliv_apple", "golden_delicious_apple", "granny_smith_apple", 0.1f);
        RecipeProvider.treeBreeding(consumer, "sweet_crabapple", "red_delicious_apple", "sugar_maple", 0.1f);
        RecipeProvider.treeBreeding(consumer, "flowering_crabapple", "sweet_crabapple", Blocks.FLOWERING_AZALEA_LEAVES, 0.1f);
        RecipeProvider.treeBreeding(consumer, "prairie_crabapple", "red_delicious_apple", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.BIRCH_LEAVES}), 0.1f);
        RecipeProvider.treeBreeding(consumer, "blackthorn", "plum", "red_delicious_apple", 0.1f);
        RecipeProvider.treeBreeding(consumer, "cherry_plum", "plum", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.CHERRY_LEAVES}), 0.1f);
        RecipeProvider.treeBreeding(consumer, "peach", "plum", "sweet_chestnut", 0.1f);
        RecipeProvider.treeBreeding(consumer, "nectarine", "plum", "peach", 0.1f);
        RecipeProvider.treeBreeding(consumer, "apricot", "plum", "peach", 0.1f);
        RecipeProvider.treeBreeding(consumer, "almond", "plum", "walnut", 0.1f);
        RecipeProvider.treeBreeding(consumer, "wild_cherry", "silver_lime", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.CHERRY_LEAVES}), 0.1f);
        RecipeProvider.treeBreeding(consumer, "sour_cherry", "white_willow", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.CHERRY_LEAVES}), 0.1f);
        RecipeProvider.treeBreeding(consumer, "black_cherry", "ceylon_ebony", "sour_cherry", 0.1f);
        RecipeProvider.treeBreeding(consumer, "orange", "mandarin", "pomelo", 0.1f);
        RecipeProvider.treeBreeding(consumer, "mandarin", "pomelo", "wild_cherry", 0.1f);
        RecipeProvider.treeBreeding(consumer, "tangerine", "mandarin", "kumquat", 0.1f);
        RecipeProvider.treeBreeding(consumer, "satsuma", "mandarin", "kumquat", 0.1f);
        RecipeProvider.treeBreeding(consumer, "lime", "pomelo", "key_lime", 0.1f);
        RecipeProvider.treeBreeding(consumer, "key_lime", "citron", "wild_cherry", 0.1f);
        RecipeProvider.treeBreeding(consumer, "finger_lime", "citron", "key_lime", 0.1f);
        RecipeProvider.treeBreeding(consumer, "pomelo", "citron", "wild_cherry", 0.1f);
        RecipeProvider.treeBreeding(consumer, "grapefruit", "pomelo", "orange", 0.1f);
        RecipeProvider.treeBreeding(consumer, "kumquat", "mandarin", "wild_cherry", 0.1f);
        RecipeProvider.treeBreeding(consumer, "lemon", "pomelo", "citron", 0.1f);
        RecipeProvider.treeBreeding(consumer, "buddhas_hand", "mandarin", "citron", 0.1f);
        RecipeProvider.treeBreeding(consumer, "banana", "balsa", "cacao", 0.1f);
        RecipeProvider.treeBreeding(consumer, "red_banana", "banana", "kapok", 0.1f);
        RecipeProvider.treeBreeding(consumer, "plantain", "banana", "teak", 0.1f);
        RecipeProvider.treeBreeding(consumer, "butternut", "walnut", "wild_cherry", 0.1f);
        RecipeProvider.treeBreeding(consumer, "rowan", "aspen", "alder", 0.1f);
        RecipeProvider.treeBreeding(consumer, "western_hemlock", "bull_pine", "silver_fir", 3.0f);
        RecipeProvider.treeBreeding(consumer, "ash", "silver_lime", Blocks.SPRUCE_LEAVES, 0.1f);
        RecipeProvider.treeBreeding(consumer, "alder", "beech", Blocks.BIRCH_LEAVES, 0.1f);
        RecipeProvider.treeBreeding(consumer, "beech", Blocks.OAK_LEAVES, Blocks.BIRCH_LEAVES, 0.5f);
        RecipeProvider.treeBreeding(consumer, "aspen", "beech", "alder", 0.1f);
        RecipeProvider.treeBreeding(consumer, "yew", "european_larch", Blocks.SPRUCE_LEAVES, 0.1f);
        RecipeProvider.treeBreeding(consumer, "lawson_cypress", "bull_pine", Blocks.SPRUCE_LEAVES, 0.1f);
        RecipeProvider.treeBreeding(consumer, "cork_oak", "lawson_cypress", Blocks.OAK_LEAVES, 0.1f);
        RecipeProvider.treeBreeding(consumer, "douglas_fir", "silver_fir", Blocks.SPRUCE_LEAVES, 0.1f);
        RecipeProvider.treeBreeding(consumer, "hazel", "aspen", "beech", 0.1f);
        RecipeProvider.treeBreeding(consumer, "sycamore_fig", "ash", "sugar_maple", 0.1f);
        RecipeProvider.treeBreeding(consumer, "breadfruit", "sycamore_fig", "sugar_maple", 0.1f);
        RecipeProvider.treeBreeding(consumer, "cempedak", "sycamore_fig", "breadfruit", 0.1f);
        RecipeProvider.treeBreeding(consumer, "jackfruit", "cempedak", "breadfruit", 0.1f);
        RecipeProvider.treeBreeding(consumer, "whitebeam", "ash", Blocks.BIRCH_LEAVES, 0.1f);
        RecipeProvider.treeBreeding(consumer, "hawthorn", "rowan", "beech", 0.1f);
        RecipeProvider.treeBreeding(consumer, "pecan", "beech", Blocks.BIRCH_LEAVES, 0.1f);
        RecipeProvider.treeBreeding(consumer, "sugar_apple", "pecan", "wild_cherry", 0.1f);
        RecipeProvider.treeBreeding(consumer, "soursop", "sugar_apple", "banana", 0.1f);
        RecipeProvider.treeBreeding(consumer, "elm", "ash", "silver_lime", 0.1f);
        RecipeProvider.treeBreeding(consumer, "elderberry", "aspen", "alder", 0.1f);
        RecipeProvider.treeBreeding(consumer, "holly", "alder", "rowan", 0.1f);
        RecipeProvider.treeBreeding(consumer, "hornbeam", "ash", "whitebeam", 0.1f);
        RecipeProvider.treeBreeding(consumer, "great_sallow", "white_willow", "aspen", 0.1f);
        RecipeProvider.treeBreeding(consumer, "silver_fir", "balsam_fir", "bull_pine", 0.1f);
        RecipeProvider.treeBreeding(consumer, "cedar", "silver_fir", "european_larch", 0.1f);
        RecipeProvider.treeBreeding(consumer, "olive", "alder", "wild_cherry", 0.1f);
        RecipeProvider.treeBreeding(consumer, "red_maple", "silver_lime", "european_larch", 0.1f);
        RecipeProvider.treeBreeding(consumer, "balsam_fir", "alder", "european_larch", 0.1f);
        RecipeProvider.treeBreeding(consumer, "loblolly_pine", "bull_pine", Blocks.SPRUCE_LEAVES, 0.1f);
        RecipeProvider.treeBreeding(consumer, "sweetgum", "european_larch", "sugar_maple", 0.1f);
        RecipeProvider.treeBreeding(consumer, "rubber_tree", "sweetgum", "loblolly_pine", 0.1f);
        RecipeProvider.treeBreeding(consumer, "black_locust", "balsa", "silver_lime", 0.1f);
        RecipeProvider.treeBreeding(consumer, "sand_pear", "red_delicious_apple", Blocks.FLOWERING_AZALEA_LEAVES, 0.1f);
        RecipeProvider.treeBreeding(consumer, "cultivated_pear", "red_delicious_apple", "sand_pear", 0.1f);
        RecipeProvider.treeBreeding(consumer, "osage_orange", "kapok", "old_fustic", 0.1f);
        RecipeProvider.treeBreeding(consumer, "old_fustic", "red_maple", "mahogany", 0.1f);
        RecipeProvider.treeBreeding(consumer, "brazilwood", "teak", "mahogany", 0.1f);
        RecipeProvider.treeBreeding(consumer, "sandalwood", "brazilwood", "mahogany", 0.1f);
        RecipeProvider.treeBreeding(consumer, "logwood", "kapok", "rosewood", 0.1f);
        RecipeProvider.treeBreeding(consumer, "rosewood", "mahogany", "teak", 0.1f);
        RecipeProvider.treeBreeding(consumer, "purpleheart", "brazilwood", "kapok", 0.1f);
        RecipeProvider.treeBreeding(consumer, "iroko", "balsa", "teak", 0.1f);
        RecipeProvider.treeBreeding(consumer, "ginkgo", "wenge", "silver_lime", 0.1f);
        RecipeProvider.treeBreeding(consumer, "brazil_nut", "beech", "cacao", 0.1f);
        RecipeProvider.treeBreeding(consumer, "rose_gum", "balsa", Blocks.FLOWERING_AZALEA_LEAVES, 0.1f);
        RecipeProvider.treeBreeding(consumer, "swamp_gum", "yellow_meranti", "rose_gum", 0.1f);
        RecipeProvider.treeBreeding(consumer, "boxwood", "holly", "alder", 0.1f);
        RecipeProvider.treeBreeding(consumer, "coffea", "black_cherry", "cacao", 0.1f);
        RecipeProvider.treeBreeding(consumer, "clove", "coffea", "teak", 0.1f);
        RecipeProvider.treeBreeding(consumer, "monkey_puzzle", "western_hemlock", Blocks.JUNGLE_LEAVES, 0.1f);
        RecipeProvider.treeBreeding(consumer, "rainbow_gum", "balsa", "rose_gum", 0.1f);
        RecipeProvider.treeBreeding(consumer, "pink_ivory", "brazilwood", "rose_gum", 0.1f);
        RecipeProvider.treeBreeding(consumer, "juniper", "elderberry", "silver_fir", 0.1f);
        RecipeProvider.treeBreeding(consumer, "cinnamon", "rosewood", "teak", 0.1f);
        RecipeProvider.treeBreeding(consumer, "coconut", "brazil_nut", "balsa", 0.1f);
        RecipeProvider.treeBreeding(consumer, "cashew", "teak", Blocks.MANGROVE_LEAVES, 0.1f);
        RecipeProvider.treeBreeding(consumer, "pistachio", "almond", "cashew", 0.1f);
        RecipeProvider.treeBreeding(consumer, "avocado", "wenge", Blocks.OAK_LEAVES, 0.1f);
        RecipeProvider.treeBreeding(consumer, "nutmeg", "teak", "clove", 0.1f);
        RecipeProvider.treeBreeding(consumer, "allspice", "teak", "clove", 0.1f);
        RecipeProvider.treeBreeding(consumer, "star_anise", "clove", "allspice", 0.1f);
        RecipeProvider.treeBreeding(consumer, "mango", "orange", Blocks.MANGROVE_LEAVES, 0.1f);
        RecipeProvider.treeBreeding(consumer, "star_fruit", "mango", "star_anise", 0.1f);
        RecipeProvider.treeBreeding(consumer, "candlenut", "ginkgo", "hazel", 0.1f);
        RecipeProvider.treeBreeding(consumer, "copoazu", "cacao", "candlenut", 0.1f);
        RecipeProvider.treeBreeding(consumer, "carob", "sweet_chestnut", "copoazu", 0.1f);
        RecipeProvider.treeBreeding(consumer, "pandanus", "walnut", "coconut", 0.1f);
        RecipeProvider.treeBreeding(consumer, "salak", "pandanus", "coconut", 0.1f);
        RecipeProvider.treeBreeding(consumer, "purple_spiral", "blue_yonder", "firecracker", 0.05f);
        RecipeProvider.treeBreeding(consumer, "cave_dweller", "black_ember", "soul_tree", 0.05f);
        RecipeProvider.treeBreeding(consumer, "foggy_blast", "cave_dweller", "soul_tree", 0.05f);
        RecipeProvider.treeBreeding(consumer, "night_fuchsia", "purple_spiral", "sparkle_cherry", 0.05f);
        RecipeProvider.treeBreeding(consumer, "time_traveller", "blue_yonder", "rippling_willow", 0.05f);
        RecipeProvider.treeBreeding(consumer, "sparkle_cherry", "firecracker", "soul_tree", 0.05f);
        RecipeProvider.treeBreeding(consumer, "slimy_delight", "rippling_willow", "soul_tree", 0.05f);
        RecipeProvider.treeBreeding(consumer, "thunder_bolt", "firecracker", "flickering_sun", 0.05f);
        RecipeProvider.treeBreeding(consumer, "rippling_willow", "blue_yonder", "flickering_sun", 0.05f);
        RecipeProvider.treeBreeding(consumer, "water_wonder", "blue_yonder", "soul_tree", 0.05f);
    }

    public static void treeBreeding(RecipeOutput consumer, String name, String leafA, String leafB, float chance) {
        RecipeProvider.treeBreeding(consumer, name, leafA, (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)(leafB + "_leaves"))), chance);
    }

    public static void treeBreeding(RecipeOutput consumer, String name, String leafA, Block leafB, float chance) {
        RecipeProvider.treeBreeding(consumer, name, (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)(leafA + "_leaves"))), leafB, chance);
    }

    public static void treeBreeding(RecipeOutput consumer, String name, String leafA, Ingredient leafB, float chance) {
        RecipeProvider.treeBreeding(consumer, name, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)(leafA + "_leaves")))}), leafB, new ItemStack((ItemLike)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)(name + "_sapling")))), chance);
    }

    public static void treeBreeding(RecipeOutput consumer, String name, Ingredient leafA, Ingredient leafB, float chance) {
        RecipeProvider.treeBreeding(consumer, name, leafA, leafB, new ItemStack((ItemLike)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)(name + "_sapling")))), chance);
    }

    public static void treeBreeding(RecipeOutput consumer, String name, Block leafA, Block leafB, float chance) {
        RecipeProvider.treeBreeding(consumer, name, leafA, leafB, name, chance);
    }

    public static void treeBreeding(RecipeOutput consumer, String name, Block leafA, Block leafB, String saplingName, float chance) {
        RecipeProvider.treeBreeding(consumer, name, leafA, leafB, (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)(saplingName + "_sapling"))), chance);
    }

    public static void treeBreeding(RecipeOutput consumer, String name, Block leafA, Block leafB, Block result, float chance) {
        RecipeProvider.treeBreeding(consumer, name, Ingredient.of((ItemLike[])new ItemLike[]{leafA}), Ingredient.of((ItemLike[])new ItemLike[]{leafB}), new ItemStack((ItemLike)result), chance);
    }

    public static void treeBreeding(RecipeOutput consumer, String name, Ingredient leafA, Ingredient leafB, ItemStack result, float chance) {
        if (leafA.isEmpty()) {
            throw new RuntimeException("Empty leafA for tree " + name);
        }
        if (leafB.isEmpty()) {
            throw new RuntimeException("Empty leafB for tree " + name);
        }
        if (result.isEmpty()) {
            throw new RuntimeException("Empty result for tree " + name);
        }
        TreePollinationRecipeBuilder.direct(leafA, leafB, result, chance).save(consumer, ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)("pollination/" + name)));
    }

    private static Ingredient getLeafIngredient(String ... treeNames) {
        Stream<ItemStack> leaves = Arrays.stream(treeNames).map(s -> new ItemStack((ItemLike)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"productivetrees", (String)(s + "_leaves")))));
        return Ingredient.of(leaves);
    }
}

