/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.common.block;

import cy.jdkdigital.productivetrees.client.particle.ColoredParticleType;
import cy.jdkdigital.productivetrees.registry.ClientRegistration;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ProductiveLeavesBlock
extends LeavesBlock {
    protected final TreeObject treeObject;

    public ProductiveLeavesBlock(BlockBehaviour.Properties properties, TreeObject treeObject) {
        super(properties);
        this.treeObject = treeObject;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        BlockPos blockpos;
        BlockState blockstate;
        super.animateTick(state, level, pos, rand);
        if (this.treeObject.hasFallingLeaves() && rand.nextInt(10) == 0 && !ProductiveLeavesBlock.isFaceFull((VoxelShape)(blockstate = level.getBlockState(blockpos = pos.below())).getCollisionShape((BlockGetter)level, blockpos), (Direction)Direction.UP)) {
            ColoredParticleType particle = (ColoredParticleType)((Object)ClientRegistration.PETAL_PARTICLES.get());
            particle.setColor(((TextColor)TextColor.parseColor((String)this.treeObject.getLeafColor()).result().get()).getValue());
            ParticleUtils.spawnParticleBelow((Level)level, (BlockPos)pos, (RandomSource)rand, (ParticleOptions)particle);
        }
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        pLevel.setBlock(pPos, ProductiveLeavesBlock.updateDistance(pState, (LevelAccessor)pLevel, pPos), 3);
    }

    private static BlockState updateDistance(BlockState pState, LevelAccessor pLevel, BlockPos pPos) {
        int i = 7;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int x = -1; x <= 1; ++x) {
            block1: for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (z == 0 && x == 0 && y == 0) continue;
                    mutableBlockPos.setWithOffset((Vec3i)pPos, x, y, z);
                    i = Math.min(i, ProductiveLeavesBlock.getOptionalDistanceAt((BlockState)pLevel.getBlockState((BlockPos)mutableBlockPos)).orElse(7) + 1);
                    if (i == 1) continue block1;
                }
            }
        }
        return (BlockState)pState.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    public TreeObject getTree() {
        return this.treeObject;
    }
}

