/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.vertex.format.impl;

import org.embeddedt.embeddium.impl.gl.attribute.GlVertexAttributeFormat;
import org.embeddedt.embeddium.impl.gl.attribute.GlVertexFormat;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkMeshAttribute;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexEncoder;
import org.embeddedt.embeddium.impl.render.chunk.vertex.format.ChunkVertexType;
import org.lwjgl.system.MemoryUtil;

public class CompactChunkVertex
implements ChunkVertexType {
    public static final GlVertexFormat<ChunkMeshAttribute> VERTEX_FORMAT = GlVertexFormat.builder(ChunkMeshAttribute.class, 20).addElement(ChunkMeshAttribute.POSITION_MATERIAL_MESH, 0, GlVertexAttributeFormat.UNSIGNED_SHORT, 4, false, true).addElement(ChunkMeshAttribute.COLOR_SHADE, 8, GlVertexAttributeFormat.UNSIGNED_BYTE, 4, true, false).addElement(ChunkMeshAttribute.BLOCK_TEXTURE, 12, GlVertexAttributeFormat.UNSIGNED_SHORT, 2, false, false).addElement(ChunkMeshAttribute.LIGHT_TEXTURE, 16, GlVertexAttributeFormat.UNSIGNED_SHORT, 2, false, true).build();
    public static final int STRIDE = 20;
    private static final int POSITION_MAX_VALUE = 65536;
    private static final int TEXTURE_MAX_VALUE = 32768;
    private static final float MODEL_ORIGIN = 8.0f;
    private static final float MODEL_RANGE = 32.0f;
    private static final float MODEL_SCALE = 4.8828125E-4f;
    private static final float MODEL_SCALE_INV = 2048.0f;
    private static final float TEXTURE_SCALE = 3.0517578E-5f;

    @Override
    public float getTextureScale() {
        return 3.0517578E-5f;
    }

    @Override
    public float getPositionScale() {
        return 4.8828125E-4f;
    }

    @Override
    public float getPositionOffset() {
        return -8.0f;
    }

    @Override
    public GlVertexFormat<ChunkMeshAttribute> getVertexFormat() {
        return VERTEX_FORMAT;
    }

    @Override
    public ChunkVertexEncoder getEncoder() {
        return (ptr, material, vertex, sectionIndex) -> {
            MemoryUtil.memPutShort((long)(ptr + 0L), (short)CompactChunkVertex.encodePosition(vertex.x));
            MemoryUtil.memPutShort((long)(ptr + 2L), (short)CompactChunkVertex.encodePosition(vertex.y));
            MemoryUtil.memPutShort((long)(ptr + 4L), (short)CompactChunkVertex.encodePosition(vertex.z));
            MemoryUtil.memPutByte((long)(ptr + 6L), (byte)((byte)(material.bits() & 0xFF)));
            MemoryUtil.memPutByte((long)(ptr + 7L), (byte)((byte)(sectionIndex & 0xFF)));
            MemoryUtil.memPutInt((long)(ptr + 8L), (int)vertex.color);
            MemoryUtil.memPutShort((long)(ptr + 12L), (short)CompactChunkVertex.encodeTexture(vertex.u));
            MemoryUtil.memPutShort((long)(ptr + 14L), (short)CompactChunkVertex.encodeTexture(vertex.v));
            MemoryUtil.memPutInt((long)(ptr + 16L), (int)vertex.light);
            return ptr + 20L;
        };
    }

    private static short encodePosition(float value) {
        return (short)((8.0f + value) * 2048.0f);
    }

    public static float decodePosition(short value) {
        return (float)Short.toUnsignedInt(value) / 2048.0f - 8.0f;
    }

    private static short encodeTexture(float value) {
        return (short)(Math.round(value * 32768.0f) & 0xFFFF);
    }
}

