/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.core.mixin;

import com.stal111.forbidden_arcanus.common.item.component.EffectGrantingRule;
import com.stal111.forbidden_arcanus.core.init.ModDataComponents;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract ItemStack getItemBySlot(EquipmentSlot var1);

    @Inject(at={@At(value="HEAD")}, method={"hasEffect"}, cancellable=true)
    public void forbiddenArcanus_hasEffect$preventEffect(Holder<MobEffect> effect, CallbackInfoReturnable<Boolean> cir) {
        EquipmentSlot[] equipmentSlotArray = this.level();
        if (equipmentSlotArray instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)equipmentSlotArray;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack stack = this.getItemBySlot(slot);
                List rules = (List)stack.getOrDefault(ModDataComponents.GRANTS_EFFECTS, List.of());
                for (EffectGrantingRule rule : rules) {
                    if (!rule.shouldGrantEffect(serverLevel, slot, effect, (Entity)((LivingEntity)this))) continue;
                    cir.setReturnValue((Object)true);
                    return;
                }
            }
        }
    }
}

