/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.world.feature;

import com.mojang.serialization.Codec;
import com.stal111.forbidden_arcanus.common.world.feature.config.BigFungyssFeatureConfig;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.neoforged.neoforge.common.Tags;

public class BigFungyssFeature
extends Feature<BigFungyssFeatureConfig> {
    public BigFungyssFeature(Codec<BigFungyssFeatureConfig> codec) {
        super(codec);
    }

    private int getRandomHeight(RandomSource random, int variant) {
        if (variant == 0) {
            return random.nextInt(3) + 4;
        }
        return random.nextInt(2) + 6;
    }

    private boolean canGenerate(LevelAccessor world, ChunkGenerator generator, BlockPos pos, int height, BlockPos.MutableBlockPos mutable) {
        if (pos.getY() < 1 || pos.getY() + height + 1 >= generator.getGenDepth()) {
            return false;
        }
        if (!world.getBlockState(pos.below()).is(Tags.Blocks.STONES)) {
            return false;
        }
        for (int i = 0; i <= height; ++i) {
            BlockState state = world.getBlockState((BlockPos)mutable.setWithOffset((Vec3i)pos, 0, i, 0));
            if (state.isAir()) continue;
            return false;
        }
        return true;
    }

    public boolean place(@Nonnull FeaturePlaceContext<BigFungyssFeatureConfig> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        int height = this.getRandomHeight(random, ((BigFungyssFeatureConfig)context.config()).variant);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        if (!this.canGenerate((LevelAccessor)level, context.chunkGenerator(), pos, height, mutable)) {
            return false;
        }
        this.placeCap((LevelAccessor)level, random, pos, height, mutable, (BigFungyssFeatureConfig)context.config());
        this.placeStem((LevelAccessor)level, random, pos, height, mutable, (BigFungyssFeatureConfig)context.config());
        return true;
    }

    private void placeStem(LevelAccessor world, RandomSource random, BlockPos pos, int height, BlockPos.MutableBlockPos mutable, BigFungyssFeatureConfig config) {
        for (int i = 0; i < height; ++i) {
            mutable.set((Vec3i)pos).move(Direction.UP, i);
            if (world.getBlockState((BlockPos)mutable).isSolidRender((BlockGetter)world, (BlockPos)mutable)) continue;
            this.setBlock((LevelWriter)world, (BlockPos)mutable, config.stemProvider.getState(random, pos));
        }
    }

    private void placeCap(LevelAccessor world, RandomSource random, BlockPos pos, int height, BlockPos.MutableBlockPos mutable, BigFungyssFeatureConfig config) {
        if (config.variant == 0) {
            int distanceToStem = 1;
            for (int i = height - 2; i <= height; ++i) {
                for (int xOffset = -distanceToStem; xOffset <= distanceToStem; ++xOffset) {
                    for (int zOffset = -distanceToStem; zOffset <= distanceToStem; ++zOffset) {
                        if ((i >= height || xOffset == 0 && zOffset == 0) && this.isCorner(xOffset, zOffset, distanceToStem)) continue;
                        mutable.setWithOffset((Vec3i)pos, xOffset, i, zOffset);
                        this.setBlock((LevelWriter)world, (BlockPos)mutable, config.capProvider.getState(random, pos));
                    }
                }
            }
            this.setBlock((LevelWriter)world, pos.above(height), config.capProvider.getState(random, pos));
        } else {
            for (int i = height - 2; i <= height; ++i) {
                int distanceToStem = i < height ? 2 : 1;
                for (int xOffset = -distanceToStem; xOffset <= distanceToStem; ++xOffset) {
                    for (int zOffset = -distanceToStem; zOffset <= distanceToStem; ++zOffset) {
                        if (i < height && this.isCorner(xOffset, zOffset, distanceToStem)) continue;
                        mutable.setWithOffset((Vec3i)pos, xOffset, i, zOffset);
                        this.setBlock((LevelWriter)world, (BlockPos)mutable, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)config.capProvider.getState(random, pos).setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.valueOf(i >= height - 1))).setValue((Property)HugeMushroomBlock.WEST, (Comparable)Boolean.valueOf(xOffset < 0))).setValue((Property)HugeMushroomBlock.EAST, (Comparable)Boolean.valueOf(xOffset > 0))).setValue((Property)HugeMushroomBlock.NORTH, (Comparable)Boolean.valueOf(zOffset < 0))).setValue((Property)HugeMushroomBlock.SOUTH, (Comparable)Boolean.valueOf(zOffset > 0)));
                    }
                }
            }
            for (Direction direction : Direction.values()) {
                if (direction.getAxis() == Direction.Axis.Y) continue;
                mutable.setWithOffset((Vec3i)pos, 0, height - 4, 0);
                mutable.move(direction);
                this.setBlock((LevelWriter)world, (BlockPos)mutable, (BlockState)config.capProvider.getState(random, pos).setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction.getOpposite()), (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    private boolean isCorner(int xOffset, int zOffset, int distanceToStem) {
        return (xOffset == -distanceToStem || xOffset == distanceToStem) == (zOffset == -distanceToStem || zOffset == distanceToStem);
    }
}

