/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.event;

import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceType;
import com.stal111.forbidden_arcanus.common.essence.EssenceHelper;
import com.stal111.forbidden_arcanus.common.item.QuantumCatcherItem;
import com.stal111.forbidden_arcanus.common.item.modifier.SoulboundInventory;
import com.stal111.forbidden_arcanus.common.network.clientbound.UpdateEssencePayload;
import com.stal111.forbidden_arcanus.core.config.BlockConfig;
import com.stal111.forbidden_arcanus.core.init.ModBlocks;
import com.stal111.forbidden_arcanus.core.init.other.ModAttachmentTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class PlayerEvents {
    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        if (player.onClimbable() && !player.isCrouching() && player.getInBlockState().is((Block)ModBlocks.EDELWOOD_LADDER.get())) {
            double multiplier = (Double)BlockConfig.EDELWOOD_LADDER_SPEED.get();
            if (!player.horizontalCollision) {
                multiplier *= (double)0.3f;
            }
            player.move(MoverType.SELF, new Vec3(0.0, player.getDeltaMovement().y * multiplier, 0.0));
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            entity = stack.getItem();
            if (entity instanceof QuantumCatcherItem) {
                QuantumCatcherItem item = (QuantumCatcherItem)entity;
                event.setCancellationResult(item.onEntityInteract(stack, player, entity2));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            EssenceHelper.getEssenceProvider((Entity)player).ifPresent(provider -> PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new UpdateEssencePayload(provider.asStorage(EssenceType.AUREAL)), (CustomPacketPayload[])new CustomPacketPayload[0]));
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            SoulboundInventory inventory = (SoulboundInventory)player2.getData(ModAttachmentTypes.SOULBOUND_INVENTORY);
            for (SoulboundInventory.Entry entry : inventory.entries()) {
                player2.getInventory().setItem(entry.slot(), entry.stack());
            }
        }
    }
}

