/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.storage;

import com.yogpc.qp.FluidStackLike;
import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.machine.MachineStorage;
import com.yogpc.qp.machine.storage.DebugStorageEntity;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;

final class ItemCountList
extends ObjectSelectionList<ItemCountRow> {
    final DebugStorageEntity storageEntity;

    public ItemCountList(Minecraft minecraft, int width, int height, int y, DebugStorageEntity storageEntity) {
        super(minecraft, width, height, y, 22);
        this.storageEntity = storageEntity;
        this.setRenderHeader(false, 0);
        this.refreshEntries();
    }

    void refreshEntries() {
        this.replaceEntries(Stream.concat(this.storageEntity.storage.itemKeyCounts().stream().map(x$0 -> new ItemCountRow((MachineStorage.ItemKeyCount)x$0)), this.storageEntity.storage.fluidKeyCounts().stream().map(x$0 -> new ItemCountRow((MachineStorage.FluidKeyCount)x$0))).toList());
    }

    protected void renderListBackground(GuiGraphics guiGraphics) {
    }

    protected boolean isSelectedItem(int index) {
        return false;
    }

    public int getRowWidth() {
        return this.getWidth() - 10;
    }

    protected int getScrollbarPosition() {
        return this.getRight() - 6;
    }

    protected void renderDecorations(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ItemCountRow hovered;
        super.renderDecorations(guiGraphics, mouseX, mouseY);
        if (this.isMouseOver(mouseX, mouseY) && (hovered = (ItemCountRow)this.getHovered()) != null) {
            guiGraphics.renderTooltip(this.minecraft.font, hovered.stack, mouseX, mouseY);
        }
    }

    class ItemCountRow
    extends ObjectSelectionList.Entry<ItemCountRow> {
        final ItemStack stack;
        final Component name;
        final long count;
        final String unit;

        ItemCountRow(MachineStorage.ItemKeyCount item) {
            this.stack = item.key().toStack(1);
            this.count = item.count();
            this.name = this.stack.getHoverName();
            this.unit = "";
        }

        ItemCountRow(MachineStorage.FluidKeyCount fluid) {
            this.stack = fluid.key().fluid().getBucket().getDefaultInstance();
            this.count = fluid.count() * 1000L / 81000L;
            this.name = PlatformAccess.getAccess().getFluidName(new FluidStackLike(fluid.key().fluid(), fluid.count(), fluid.key().patch()));
            this.unit = " mB";
        }

        public Component getNarration() {
            return this.name;
        }

        public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            guiGraphics.renderFakeItem(this.stack, left, top);
            Component text = this.getNarration();
            int textWidth = ((ItemCountList)ItemCountList.this).minecraft.font.width((FormattedText)text);
            int textX = left + 20;
            int textY = top + 4;
            guiGraphics.drawString(((ItemCountList)ItemCountList.this).minecraft.font, text, textX, textY, 0xFFFFFF);
            guiGraphics.drawString(((ItemCountList)ItemCountList.this).minecraft.font, this.count + this.unit, textX + textWidth + 8, textY, 0xFFFFFF, true);
        }
    }
}

