/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machine.module;

import com.yogpc.qp.PlatformAccess;
import com.yogpc.qp.QuarryDataComponents;
import com.yogpc.qp.machine.GeneralScreenHandler;
import com.yogpc.qp.machine.MachineStorage;
import com.yogpc.qp.machine.QpItem;
import com.yogpc.qp.machine.module.ConverterModule;
import com.yogpc.qp.machine.module.FilterModuleContainer;
import com.yogpc.qp.machine.module.QuarryModule;
import com.yogpc.qp.machine.module.QuarryModuleProvider;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public final class FilterModuleItem
extends QpItem
implements QuarryModuleProvider.Item {
    public static final String NAME = "filter_module";

    public FilterModuleItem() {
        super(new Item.Properties().stacksTo(1), NAME);
    }

    @Override
    public QuarryModule getModule(@NotNull ItemStack stack) {
        Set<MachineStorage.ItemKey> targets = Set.copyOf((Collection)stack.getOrDefault(QuarryDataComponents.ITEM_KEY_LIST_COMPONENT, List.of()));
        return new ConverterModule.FilterModule(targets);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (!level.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlatformAccess.getAccess().openGui(serverPlayer, new GeneralScreenHandler<FilterModuleContainer>(player.getOnPos(), stack.getHoverName(), (syncId, inventory, pos) -> new FilterModuleContainer(syncId, inventory, stack)));
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"quarryplus.tooltip.filter_module_1"));
        tooltipComponents.add((Component)Component.translatable((String)"quarryplus.tooltip.filter_module_2"));
        List itemList = (List)stack.get(QuarryDataComponents.ITEM_KEY_LIST_COMPONENT);
        if (itemList != null && !itemList.isEmpty()) {
            if (Screen.hasShiftDown()) {
                itemList.stream().map(MachineStorage.ItemKey::item).filter(Predicate.isEqual(Items.AIR).negate()).map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0)).map(arg_0 -> FilterModuleItem.lambda$appendHoverText$1("  %s", arg_0)).map(Component::literal).forEach(tooltipComponents::add);
            } else {
                MutableComponent first = Component.literal((String)"  %s".formatted(BuiltInRegistries.ITEM.getKey((Object)((MachineStorage.ItemKey)itemList.getFirst()).item())));
                tooltipComponents.add((Component)first);
                if (itemList.size() > 1) {
                    tooltipComponents.add((Component)Component.literal((String)"  ...(%s)".formatted(itemList.size() - 1)));
                }
            }
        }
    }

    private static /* synthetic */ String lambda$appendHoverText$1(String rec$, Object xva$0) {
        return "  %s".formatted(xva$0);
    }
}

