/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp;

import com.yogpc.qp.FluidStackLike;
import com.yogpc.qp.InCreativeTabs;
import com.yogpc.qp.PlatformAccessHolder;
import com.yogpc.qp.config.EnableMap;
import com.yogpc.qp.config.QuarryConfig;
import com.yogpc.qp.machine.GeneralScreenHandler;
import com.yogpc.qp.machine.MachineLootFunction;
import com.yogpc.qp.machine.QpBlock;
import com.yogpc.qp.machine.QpEntity;
import com.yogpc.qp.machine.advquarry.AdvQuarryBlock;
import com.yogpc.qp.machine.advquarry.AdvQuarryContainer;
import com.yogpc.qp.machine.marker.ChunkMarkerBlock;
import com.yogpc.qp.machine.marker.FlexibleMarkerBlock;
import com.yogpc.qp.machine.marker.MarkerContainer;
import com.yogpc.qp.machine.marker.NormalMarkerBlock;
import com.yogpc.qp.machine.misc.BlockBreakEventResult;
import com.yogpc.qp.machine.misc.FrameBlock;
import com.yogpc.qp.machine.misc.GeneratorBlock;
import com.yogpc.qp.machine.misc.SoftBlock;
import com.yogpc.qp.machine.misc.YSetterContainer;
import com.yogpc.qp.machine.module.BedrockModuleItem;
import com.yogpc.qp.machine.module.FilterModuleContainer;
import com.yogpc.qp.machine.module.ModuleContainer;
import com.yogpc.qp.machine.mover.MoverBlock;
import com.yogpc.qp.machine.mover.MoverContainer;
import com.yogpc.qp.machine.placer.PlacerBlock;
import com.yogpc.qp.machine.placer.PlacerContainer;
import com.yogpc.qp.machine.placer.RemotePlacerBlock;
import com.yogpc.qp.machine.quarry.QuarryBlock;
import com.yogpc.qp.machine.storage.DebugStorageBlock;
import com.yogpc.qp.machine.storage.DebugStorageContainer;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PlatformAccess {
    public static PlatformAccess getAccess() {
        return PlatformAccessHolder.instance;
    }

    public static QuarryConfig config() {
        return PlatformAccess.getAccess().getConfig().get();
    }

    default public int priority() {
        return 0;
    }

    public String platformName();

    public RegisterObjects registerObjects();

    public Packet packetHandler();

    public Path configPath();

    public Supplier<? extends QuarryConfig> getConfig();

    public boolean isInDevelopmentEnvironment();

    public Transfer transfer();

    public FluidStackLike getFluidInItem(ItemStack var1);

    public Component getFluidName(FluidStackLike var1);

    public <T extends AbstractContainerMenu> void openGui(ServerPlayer var1, GeneralScreenHandler<T> var2);

    public Mining mining();

    public static interface Mining {
        public BlockBreakEventResult checkBreakEvent(QpEntity var1, Level var2, ServerPlayer var3, BlockState var4, BlockPos var5, @Nullable BlockEntity var6);

        public BlockBreakEventResult afterBreak(QpEntity var1, Level var2, ServerPlayer var3, BlockState var4, BlockPos var5, @Nullable BlockEntity var6, List<ItemStack> var7, ItemStack var8, BlockState var9);

        public ServerPlayer getQuarryFakePlayer(QpEntity var1, ServerLevel var2, BlockPos var3);
    }

    public static interface Transfer {
        public ItemStack transferItem(Level var1, BlockPos var2, ItemStack var3, Direction var4, boolean var5);

        public FluidStackLike transferFluid(Level var1, BlockPos var2, FluidStackLike var3, Direction var4, boolean var5);
    }

    public static interface Packet {
        public void sendToClientWorld(@NotNull CustomPacketPayload var1, @NotNull Level var2);

        public void sendToClientPlayer(@NotNull CustomPacketPayload var1, @NotNull ServerPlayer var2);

        public void sendToServer(@NotNull CustomPacketPayload var1);
    }

    public static interface RegisterObjects {
        public Supplier<? extends QuarryBlock> quarryBlock();

        public Supplier<? extends FrameBlock> frameBlock();

        public Supplier<? extends GeneratorBlock> generatorBlock();

        public Supplier<? extends NormalMarkerBlock> markerBlock();

        public Supplier<? extends MoverBlock> moverBlock();

        public Supplier<? extends FlexibleMarkerBlock> flexibleMarkerBlock();

        public Supplier<? extends ChunkMarkerBlock> chunkMarkerBlock();

        public Supplier<? extends DebugStorageBlock> debugStorageBlock();

        public Supplier<? extends AdvQuarryBlock> advQuarryBlock();

        public Supplier<? extends SoftBlock> softBlock();

        public Supplier<? extends PlacerBlock> placerBlock();

        public Supplier<? extends RemotePlacerBlock> remotePlacerBlock();

        public Optional<BlockEntityType<?>> getBlockEntityType(QpBlock var1);

        default public Collection<? extends BlockEntityType<?>> getBlockEntityTypes() {
            return BuiltInRegistries.BLOCK_ENTITY_TYPE.entrySet().stream().filter(p -> ((ResourceKey)p.getKey()).location().getNamespace().equals("quarryplus")).map(Map.Entry::getValue).toList();
        }

        public Map<String, EnableMap.EnableOrNot> defaultEnableSetting();

        public Supplier<? extends BedrockModuleItem> bedrockModuleItem();

        public Stream<Supplier<? extends InCreativeTabs>> allItems();

        public Supplier<MenuType<? extends YSetterContainer>> ySetterContainer();

        public Supplier<MenuType<? extends MoverContainer>> moverContainer();

        public Supplier<MenuType<? extends ModuleContainer>> moduleContainer();

        public Supplier<MenuType<? extends MarkerContainer>> flexibleMarkerContainer();

        public Supplier<MenuType<? extends MarkerContainer>> chunkMarkerContainer();

        public Supplier<MenuType<? extends DebugStorageContainer>> debugStorageContainer();

        public Supplier<MenuType<? extends AdvQuarryContainer>> advQuarryContainer();

        public Supplier<MenuType<? extends FilterModuleContainer>> filterModuleContainer();

        public Supplier<MenuType<? extends PlacerContainer>> placerContainer();

        public Supplier<MenuType<? extends PlacerContainer>> remotePlacerContainer();

        public Supplier<LootItemFunctionType<? extends MachineLootFunction>> machineLootFunction();
    }
}

