/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.camol.common.recipe;

import cy.jdkdigital.camol.Camol;
import cy.jdkdigital.camol.common.item.CamoItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class SimpleCamoCraftingRecipe
implements CraftingRecipe {
    public SimpleCamoCraftingRecipe(CraftingBookCategory category) {
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public boolean matches(CraftingInput input, Level level) {
        return input.ingredientCount() == 2 && input.items().stream().filter(itemStack -> itemStack.is(Camol.CAMO_ITEM)).toList().size() == 1 && input.items().stream().filter(itemStack -> !itemStack.is(Camol.CRAFTING_BLACKLIST) && itemStack.getItem() instanceof BlockItem).toList().size() == 1;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack camoItem = input.items().stream().filter(itemStack -> !itemStack.is(Camol.CAMO_ITEM)).toList().getFirst();
        Item item = camoItem.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return CamoItem.getCamoItem(blockItem.getBlock().defaultBlockState());
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return Camol.CAMO_ITEM.asItem().getDefaultInstance();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)Camol.SIMPLE_CAMO_CRAFTING.get();
    }
}

