/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.google.common.collect.ImmutableList;
import com.tristankechlo.livingthings.config.entity.CrabConfig;
import com.tristankechlo.livingthings.entity.ai.BetterMeleeAttackGoal;
import com.tristankechlo.livingthings.entity.misc.IMobVariants;
import com.tristankechlo.livingthings.entity.misc.IScaleableMob;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;

public class CrabEntity
extends Animal
implements IMobVariants,
NeutralMob,
IScaleableMob,
ILexiconEntry {
    private static final EntityDataAccessor<Byte> CRAB_VARIANT = SynchedEntityData.defineId(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> CRAB_SCALING = SynchedEntityData.defineId(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final UniformInt rangedInteger = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int angerTime;
    private UUID angerTarget;

    public CrabEntity(EntityType<? extends CrabEntity> type, Level worldIn) {
        super(type, worldIn);
        this.setPathfindingMalus(PathType.WATER, 1.0f);
    }

    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        CrabEntity entityChild = (CrabEntity)ModEntityTypes.CRAB.get().create(this.level());
        entityChild.setVariant(this.getVariantFromParents((AgeableMob)this, entity));
        entityChild.setScaling(CrabEntity.getWeightedRandomScaling(this.random));
        double health = CrabConfig.health();
        if (health > 0.0) {
            entityChild.getAttribute(Attributes.MAX_HEALTH).setBaseValue(health + (double)entityChild.getScaling());
            entityChild.setHealth(entityChild.getMaxHealth());
        }
        return entityChild;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, CrabConfig.health()).add(Attributes.MOVEMENT_SPEED, CrabConfig.movementSpeed()).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.ATTACK_DAMAGE, CrabConfig.attackDamage());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new BetterMeleeAttackGoal((PathfinderMob)this, 1.05, false, CrabConfig::canAttack));
        this.goalSelector.addGoal(1, (Goal)new BreedGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public static boolean checkCrabSpawnRules(EntityType<CrabEntity> animal, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.isWaterAt(pos) || world.getBlockState(pos.below()).is(LivingThingsTags.CRAB_SPAWNABLE_ON) && CrabEntity.isBrightEnoughToSpawn((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn) {
        int colorRedWeight = (Integer)CrabConfig.get().colorRedWeight.get();
        int colorWhiteWeight = (Integer)CrabConfig.get().colorWhiteWeight.get();
        int colorBlueWeight = (Integer)CrabConfig.get().colorBlueWeight.get();
        byte variant = this.getRandomVariant(this.random, new byte[]{0, 1, 2}, new int[]{colorRedWeight, colorWhiteWeight, colorBlueWeight});
        this.setVariant(variant);
        this.setScaling(CrabEntity.getWeightedRandomScaling(this.random));
        double health = CrabConfig.health();
        if (health > 0.0) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(health + (double)this.getScaling());
            this.setHealth(this.getMaxHealth());
        }
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public static byte getWeightedRandomScaling(RandomSource random) {
        int scaling1Weight = (Integer)CrabConfig.get().scalingNormalWeight.get();
        int scaling2Weight = (Integer)CrabConfig.get().scalingLargeWeight.get();
        int scaling3Weight = (Integer)CrabConfig.get().scalingSmallWeight.get();
        int scaling4Weight = (Integer)CrabConfig.get().scalingExtraLargeWeight.get();
        if (scaling1Weight <= 0 && scaling2Weight <= 0 && scaling3Weight <= 0 && scaling4Weight <= 0) {
            return 0;
        }
        Optional scaling = WeightedRandom.getRandomItem((RandomSource)random, (List)ImmutableList.of((Object)new IScaleableMob.WeightedMobScaling(Math.max(0, scaling1Weight), 0), (Object)new IScaleableMob.WeightedMobScaling(Math.max(0, scaling2Weight), 2), (Object)new IScaleableMob.WeightedMobScaling(Math.max(0, scaling3Weight), -2), (Object)new IScaleableMob.WeightedMobScaling(Math.max(0, scaling4Weight), 6)));
        return ((IScaleableMob.WeightedMobScaling)scaling.get()).scaling;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CRAB_VARIANT, (Object)0);
        builder.define(CRAB_SCALING, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte("CrabVariant", this.getVariant());
        compound.putByte("CrabScaling", this.getScaling());
        this.addPersistentAngerSaveData(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setVariant(compound.getByte("CrabVariant"));
        this.setScaling(compound.getByte("CrabScaling"));
        this.readPersistentAngerSaveData(this.level(), compound);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(LivingThingsTags.CRAB_FOOD);
    }

    public int getMaxSpawnClusterSize() {
        return CrabConfig.maxSpawnedInChunk();
    }

    protected float getWaterSlowDown() {
        return 0.98f;
    }

    @Override
    public byte getVariant() {
        return (Byte)this.entityData.get(CRAB_VARIANT);
    }

    @Override
    public void setVariant(byte variant) {
        this.entityData.set(CRAB_VARIANT, (Object)variant);
    }

    @Override
    public byte getScaling() {
        return (Byte)this.entityData.get(CRAB_SCALING);
    }

    @Override
    public void setScaling(byte scaling) {
        this.entityData.set(CRAB_SCALING, (Object)scaling);
        this.reapplyPosition();
        this.refreshDimensions();
        this.xpReward = Math.abs(scaling) * this.random.nextInt(2);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (CRAB_SCALING.equals(key)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(key);
    }

    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        if (this.isBaby()) {
            return super.getDefaultDimensions(pose);
        }
        return super.getDefaultDimensions(pose).scale(0.85f + 0.1f * (float)this.getScaling());
    }

    public int getRemainingPersistentAngerTime() {
        return this.angerTime;
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.angerTime = time;
    }

    public UUID getPersistentAngerTarget() {
        return this.angerTarget;
    }

    public void setPersistentAngerTarget(UUID target) {
        this.angerTarget = target;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(rangedInteger.sample(this.random));
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.CRAB;
    }
}

