/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.GeneralConfig;
import com.tristankechlo.livingthings.config.entity.AncientBlazeConfig;
import com.tristankechlo.livingthings.entity.ai.AncientBlazeChargeUpGoal;
import com.tristankechlo.livingthings.init.ModItems;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;

public class AncientBlazeEntity
extends Monster
implements PowerableMob,
RangedAttackMob,
ILexiconEntry {
    private static final EntityDataAccessor<Byte> SHOOTS = SynchedEntityData.defineId(AncientBlazeEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> INVULNERABLE_TIME = SynchedEntityData.defineId(AncientBlazeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS);

    public AncientBlazeEntity(EntityType<? extends AncientBlazeEntity> type, Level world) {
        super(type, world);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
        this.xpReward = 30;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, AncientBlazeConfig.health()).add(Attributes.MOVEMENT_SPEED, AncientBlazeConfig.movementSpeed()).add(Attributes.FOLLOW_RANGE, 48.0).add(Attributes.ATTACK_DAMAGE, AncientBlazeConfig.attackDamage());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn) {
        this.setInvulnerableTime(AncientBlazeConfig.chargingTime());
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new AncientBlazeChargeUpGoal(this));
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 30, 20.0f));
        this.goalSelector.addGoal(2, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, true));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(INVULNERABLE_TIME, (Object)0);
        builder.define(SHOOTS, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("ChargedTime", this.getInvulnerableTime());
        compound.putByte("Shoots", this.getShoots());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setInvulnerableTime(compound.getInt("ChargedTime"));
        this.setShoots(compound.getByte("Shoots"));
        if (this.hasCustomName()) {
            this.bossInfo.setName(this.getDisplayName());
        }
    }

    public void setCustomName(Component name) {
        super.setCustomName(name);
        this.bossInfo.setName(this.getDisplayName());
    }

    public void aiStep() {
        if (!this.onGround() && this.getDeltaMovement().y < 0.0) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.6, 1.0));
        }
        if (this.level().isClientSide() && this.getInvulnerableTime() == 0) {
            if (this.random.nextInt(24) == 0 && !this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), ModSounds.ANCIENT_BLAZE_BURN.get(), this.getSoundSource(), 1.0f + this.random.nextFloat(), this.random.nextFloat() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.aiStep();
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(level, source, recentlyHitIn);
        ItemEntity itementity = this.spawnAtLocation((ItemLike)ModItems.ANCIENT_HELMET.get());
        if (itementity != null) {
            itementity.setExtendedLifetime();
        }
    }

    protected SoundEvent getAmbientSound() {
        return ModSounds.ANCIENT_BLAZE_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return ModSounds.ANCIENT_BLAZE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return ModSounds.ANCIENT_BLAZE_DEATH.get();
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.getInvulnerableTime() > 0 && source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        if (source.getDirectEntity() instanceof LargeFireball && source.getEntity() instanceof Player) {
            byte shoots = this.getShoots();
            if (shoots < AncientBlazeConfig.largeFireballAmount()) {
                this.setShoots((byte)(shoots + 1));
                return false;
            }
            return true;
        }
        if (!source.isDirect()) {
            return this.random.nextInt(4) != 0 && super.hurt(source, amount);
        }
        return super.hurt(source, amount);
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        boolean peaceful = this.level().getDifficulty() == Difficulty.PEACEFUL;
        boolean ambientMode = GeneralConfig.get().ambientMode.get();
        if (peaceful || ambientMode || !AncientBlazeConfig.canAttack()) {
            return;
        }
        double d1 = target.getX() - this.getX();
        double d2 = target.getY(0.5) - this.getY(0.5);
        double d3 = target.getZ() - this.getZ();
        byte shoots = this.getShoots();
        double chance = (double)AncientBlazeConfig.largeFireballChance() / 100.0;
        if (this.random.nextDouble() < chance && shoots > 0) {
            this.setShoots((byte)(shoots - 1));
            LargeFireball fireballentity = new LargeFireball(this.level(), (LivingEntity)this, new Vec3(d1, d2, d3), 1);
            fireballentity.setPos(fireballentity.getX(), this.getY(0.5) + 0.5, fireballentity.getZ());
            this.level().addFreshEntity((Entity)fireballentity);
        } else {
            SmallFireball smallfireballentity = new SmallFireball(this.level(), (LivingEntity)this, new Vec3(d1, d2, d3));
            smallfireballentity.setPos(smallfireballentity.getX(), this.getY(0.5) + 0.5, smallfireballentity.getZ());
            this.level().addFreshEntity((Entity)smallfireballentity);
        }
        if (!this.level().isClientSide()) {
            this.level().playSound(null, this.blockPosition(), ModSounds.ANCIENT_BLAZE_SHOOT.get(), SoundSource.HOSTILE, 2.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
    }

    public void remove(Entity.RemovalReason reason) {
        int amount = AncientBlazeConfig.blazeSpawnCount();
        if (!this.level().isClientSide() && amount >= 1 && this.isDeadOrDying()) {
            for (int i = 0; i < amount; ++i) {
                Blaze blaze = new Blaze(EntityType.BLAZE, this.level());
                if (this.isPersistenceRequired()) {
                    blaze.setPersistenceRequired();
                }
                blaze.setCustomName(this.getCustomName());
                blaze.setNoAi(this.isNoAi());
                blaze.setInvulnerable(this.isInvulnerable());
                blaze.moveTo(this.getX(), this.getY(), this.getZ(), this.random.nextFloat() * 360.0f, 0.0f);
                this.level().addFreshEntity((Entity)blaze);
            }
        }
        super.remove(reason);
    }

    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    protected boolean shouldDespawnInPeaceful() {
        return AncientBlazeConfig.peacefulDespawn() && super.shouldDespawnInPeaceful();
    }

    public boolean isSensitiveToWater() {
        return true;
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean causeFallDamage(float p_149683_, float p_149684_, DamageSource p_149685_) {
        return false;
    }

    public boolean onClimbable() {
        return false;
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bossInfo.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
    }

    public int getInvulnerableTime() {
        return (Integer)this.entityData.get(INVULNERABLE_TIME);
    }

    public void setInvulnerableTime(int time) {
        this.entityData.set(INVULNERABLE_TIME, (Object)time);
    }

    public byte getShoots() {
        return (Byte)this.entityData.get(SHOOTS);
    }

    public void setShoots(byte shoots) {
        this.entityData.set(SHOOTS, (Object)shoots);
    }

    public boolean isPowered() {
        return (Integer)this.entityData.get(INVULNERABLE_TIME) > 0;
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.ANCIENT_BLAZE;
    }
}

