/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.entity.CrabEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class CrabModel<T extends CrabEntity>
extends AdvancedEntityModel<T> {
    private final ModelPart Body;
    private final ModelPart Leg1;
    private final ModelPart Leg2;
    private final ModelPart Leg3;
    private final ModelPart Leg4;
    private final ModelPart Leg5;
    private final ModelPart Leg6;
    private final ModelPart Leg7;
    private final ModelPart Leg8;
    private final ModelPart Shear1;
    private final ModelPart Shear2;

    public CrabModel(ModelPart root) {
        this.Body = root.getChild("Body");
        this.Leg1 = this.Body.getChild("Leg1");
        this.Leg2 = this.Body.getChild("Leg2");
        this.Leg3 = this.Body.getChild("Leg3");
        this.Leg4 = this.Body.getChild("Leg4");
        this.Leg5 = this.Body.getChild("Leg5");
        this.Leg6 = this.Body.getChild("Leg6");
        this.Leg7 = this.Body.getChild("Leg7");
        this.Leg8 = this.Body.getChild("Leg8");
        this.Shear1 = this.Body.getChild("Shear1");
        this.Shear2 = this.Body.getChild("Shear2");
    }

    public void setupAnim(CrabEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Leg1.yRot = 0.17453292f;
        this.Leg1.zRot = 0.47996554f;
        this.Leg2.yRot = 0.04363323f;
        this.Leg2.zRot = 0.47996554f;
        this.Leg3.yRot = -0.04363323f;
        this.Leg3.zRot = 0.47996554f;
        this.Leg4.yRot = -0.17453292f;
        this.Leg4.zRot = 0.47996554f;
        this.Leg5.yRot = -2.9670596f;
        this.Leg5.zRot = -0.47996554f;
        this.Leg6.yRot = -3.0979595f;
        this.Leg6.zRot = -0.47996554f;
        this.Leg7.yRot = 3.0979595f;
        this.Leg7.zRot = -0.47996554f;
        this.Leg8.yRot = 2.9670596f;
        this.Leg8.zRot = -0.47996554f;
        float f1 = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 0.0f)) * 0.4f) * limbSwingAmount;
        float f2 = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + (float)Math.PI)) * 0.4f) * limbSwingAmount;
        float f3 = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 1.5707964f)) * 0.4f) * limbSwingAmount;
        float f4 = -(Mth.cos((float)(limbSwing * 0.6662f * 2.0f + 4.712389f)) * 0.4f) * limbSwingAmount;
        float f5 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 0.0f)) * 0.4f) * limbSwingAmount;
        float f6 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.4f) * limbSwingAmount;
        float f7 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 1.5707964f)) * 0.4f) * limbSwingAmount;
        float f8 = Math.abs(Mth.sin((float)(limbSwing * 0.6662f + 4.712389f)) * 0.4f) * limbSwingAmount;
        this.Leg1.yRot += f1;
        this.Leg2.yRot += -f1;
        this.Leg3.yRot += f2;
        this.Leg4.yRot += -f2;
        this.Leg5.yRot += f3;
        this.Leg6.yRot += -f3;
        this.Leg7.yRot += f4;
        this.Leg8.yRot += -f4;
        this.Leg1.zRot += f5;
        this.Leg2.zRot += -f5;
        this.Leg3.zRot += f6;
        this.Leg4.zRot += -f6;
        this.Leg5.zRot += f7;
        this.Leg6.zRot += -f7;
        this.Leg7.zRot += f8;
        this.Leg8.zRot += -f8;
        this.Shear1.xRot = -0.08726646f;
        this.Shear1.yRot = -0.7853982f;
        this.Shear2.xRot = -0.08726646f;
        this.Shear2.yRot = 0.7853982f;
        this.Shear1.xRot += -(Mth.cos((float)(limbSwing * 1.3324f)) * 0.75f * limbSwingAmount) / 2.0f;
        this.Shear2.xRot += Mth.cos((float)(limbSwing * 1.3324f)) * 0.75f * limbSwingAmount / 2.0f;
    }

    public void renderToBuffer(PoseStack matrixStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        if (this.young) {
            matrixStack.scale(0.6f, 0.6f, 0.6f);
            matrixStack.translate(0.0f, 1.0f, 0.0f);
        }
        this.Body.render(matrixStack, buffer, packedLight, packedOverlay);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 8).addBox(-3.0f, -1.0f, -3.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(24, 13).mirror().addBox(-1.7f, -2.5f, -3.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.01f)).mirror(false).texOffs(28, 13).mirror().addBox(0.7f, -2.5f, -3.0f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.01f)).mirror(false), PartPose.offset((float)0.0f, (float)20.4f, (float)0.0f));
        PartDefinition Shear1 = Body.addOrReplaceChild("Shear1", CubeListBuilder.create().texOffs(0, 2).addBox(-0.5f, -0.5f, -2.05f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)-0.3f, (float)-2.5f, (float)-0.0873f, (float)-0.7854f, (float)0.0f));
        PartDefinition Shear1Arm = Shear1.addOrReplaceChild("Shear1Arm", CubeListBuilder.create().texOffs(6, 3).addBox(-0.4805f, -0.5046f, -0.9277f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-1.9091f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition Shear1UpperBottom = Shear1Arm.addOrReplaceChild("Shear1UpperBottom", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.102f, (float)-0.0247f, (float)-0.7323f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition Shear1Upper = Shear1UpperBottom.addOrReplaceChild("Shear1Upper", CubeListBuilder.create().texOffs(10, 2).addBox(-0.552f, -0.9267f, -2.0836f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(16, 2).addBox(-0.552f, -1.2255f, -2.0836f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0031f, (float)0.0494f, (float)-0.0074f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition Shear1Bottom = Shear1UpperBottom.addOrReplaceChild("Shear1Bottom", CubeListBuilder.create().texOffs(22, 3).addBox(-0.552f, -0.1753f, -1.8686f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(26, 3).addBox(-0.552f, -0.1753f, -1.07f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition Shear2 = Body.addOrReplaceChild("Shear2", CubeListBuilder.create().texOffs(0, 5).addBox(-0.5f, -0.5f, -2.05f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.5f, (float)-0.3f, (float)-2.5f, (float)-0.0873f, (float)0.7854f, (float)0.0f));
        PartDefinition Shear2Arm = Shear2.addOrReplaceChild("Shear2Arm", CubeListBuilder.create().texOffs(6, 6).addBox(-0.975f, -1.0f, -0.95f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.3535f, (float)0.4994f, (float)-1.6338f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition Shear2UpperBottom = Shear2Arm.addOrReplaceChild("Shear2UpperBottom", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-0.4926f, (float)-0.4745f, (float)-0.6809f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition Shear2Upper = Shear2UpperBottom.addOrReplaceChild("Shear2Upper", CubeListBuilder.create().texOffs(10, 5).addBox(-0.552f, -1.0017f, -2.2336f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(16, 5).addBox(-0.552f, -1.3005f, -2.2336f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0031f, (float)0.0537f, (float)-0.0074f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition Shear2Bottom = Shear2UpperBottom.addOrReplaceChild("Shear2Bottom", CubeListBuilder.create().texOffs(22, 6).addBox(-0.552f, -0.2503f, -2.0186f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(26, 6).addBox(-0.552f, -0.2503f, -1.22f, 1.0f, 1.0f, 1.0f, new CubeDeformation(-0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0044f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition Leg1 = Body.addOrReplaceChild("Leg1", CubeListBuilder.create().texOffs(18, 9).addBox(0.0f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.15f, (float)0.6f, (float)-1.825f, (float)0.0f, (float)0.1745f, (float)0.48f));
        PartDefinition Leg11 = Leg1.addOrReplaceChild("Leg11", CubeListBuilder.create().texOffs(26, 9).addBox(-0.2f, -0.45f, -0.5f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.95f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition Leg2 = Body.addOrReplaceChild("Leg2", CubeListBuilder.create().texOffs(18, 9).addBox(0.0f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.25f, (float)0.6f, (float)-0.55f, (float)0.0f, (float)0.0436f, (float)0.48f));
        PartDefinition Leg22 = Leg2.addOrReplaceChild("Leg22", CubeListBuilder.create().texOffs(26, 9).addBox(-0.3012f, -0.45f, -0.5066f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0512f, (float)0.05f, (float)0.0066f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition Leg3 = Body.addOrReplaceChild("Leg3", CubeListBuilder.create().texOffs(18, 9).addBox(0.0f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.25f, (float)0.6f, (float)0.725f, (float)0.0f, (float)-0.0436f, (float)0.48f));
        PartDefinition Leg33 = Leg3.addOrReplaceChild("Leg33", CubeListBuilder.create().texOffs(26, 9).addBox(-0.3012f, -0.45f, -0.5066f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0262f, (float)0.05f, (float)0.0066f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition Leg4 = Body.addOrReplaceChild("Leg4", CubeListBuilder.create().texOffs(18, 9).addBox(0.0f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.175f, (float)0.6f, (float)2.0f, (float)0.0f, (float)-0.1745f, (float)0.48f));
        PartDefinition Leg44 = Leg4.addOrReplaceChild("Leg44", CubeListBuilder.create().texOffs(26, 9).addBox(-0.3012f, -0.45f, -0.5066f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0262f, (float)0.05f, (float)0.0066f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition Leg5 = Body.addOrReplaceChild("Leg5", CubeListBuilder.create().texOffs(18, 11).addBox(0.0f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.2f, (float)0.525f, (float)2.0f, (float)0.0f, (float)-2.9671f, (float)-0.48f));
        PartDefinition Leg55 = Leg5.addOrReplaceChild("Leg55", CubeListBuilder.create().texOffs(26, 11).addBox(-0.3012f, -0.45f, -0.5066f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0262f, (float)0.05f, (float)0.0066f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition Leg6 = Body.addOrReplaceChild("Leg6", CubeListBuilder.create().texOffs(18, 11).addBox(0.0f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.325f, (float)0.6f, (float)0.75f, (float)0.0f, (float)-3.098f, (float)-0.48f));
        PartDefinition Leg66 = Leg6.addOrReplaceChild("Leg66", CubeListBuilder.create().texOffs(26, 11).addBox(-0.3012f, -0.45f, -0.5066f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0262f, (float)0.05f, (float)0.0066f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition Leg7 = Body.addOrReplaceChild("Leg7", CubeListBuilder.create().texOffs(18, 11).addBox(0.0f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.275f, (float)0.6f, (float)-0.675f, (float)0.0f, (float)3.098f, (float)-0.48f));
        PartDefinition Leg77 = Leg7.addOrReplaceChild("Leg77", CubeListBuilder.create().texOffs(26, 11).addBox(-0.3012f, -0.45f, -0.5066f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0262f, (float)0.05f, (float)0.0066f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition Leg8 = Body.addOrReplaceChild("Leg8", CubeListBuilder.create().texOffs(18, 11).addBox(0.0f, -0.5f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.175f, (float)0.6f, (float)-2.025f, (float)0.0f, (float)2.9671f, (float)-0.48f));
        PartDefinition Leg88 = Leg8.addOrReplaceChild("Leg88", CubeListBuilder.create().texOffs(26, 11).addBox(-0.3012f, -0.45f, -0.5066f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0262f, (float)0.05f, (float)0.0066f, (float)0.0f, (float)0.0f, (float)0.5236f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)16);
    }
}

