/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.network.packet;

import appeng.api.features.HotkeyAction;
import appeng.core.AELog;
import appeng.core.localization.PlayerMessages;
import appeng.core.network.CustomAppEngPayload;
import appeng.core.network.ServerboundPacket;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.pedroksl.advanced_ae.client.Hotkeys;
import net.pedroksl.advanced_ae.common.definitions.AAEHotkeys;

public record AAEHotkeyPacket(String hotkey) implements ServerboundPacket
{
    public static final StreamCodec<RegistryFriendlyByteBuf, AAEHotkeyPacket> STREAM_CODEC = StreamCodec.ofMember(AAEHotkeyPacket::write, AAEHotkeyPacket::decode);
    public static final CustomPacketPayload.Type<AAEHotkeyPacket> TYPE = CustomAppEngPayload.createType((String)"aae_hotkey");

    public AAEHotkeyPacket(Hotkeys.AAEHotkey hotkey) {
        this(hotkey.name());
    }

    public CustomPacketPayload.Type<AAEHotkeyPacket> type() {
        return TYPE;
    }

    public static AAEHotkeyPacket decode(RegistryFriendlyByteBuf stream) {
        String hotkey = stream.readUtf();
        return new AAEHotkeyPacket(hotkey);
    }

    public void write(RegistryFriendlyByteBuf data) {
        data.writeUtf(this.hotkey);
    }

    public void handleOnServer(ServerPlayer player) {
        List<HotkeyAction> actions = AAEHotkeys.REGISTRY.get(this.hotkey);
        if (actions == null) {
            player.sendSystemMessage((Component)PlayerMessages.UnknownHotkey.text().copy().append((Component)Component.translatable((String)("key.advanced_ae." + this.hotkey))));
            AELog.warn((String)"Player %s tried using unknown hotkey \"%s\"", (Object[])new Object[]{player, this.hotkey});
            return;
        }
        for (HotkeyAction action : actions) {
            if (action.run((Player)player)) break;
        }
    }
}

